/**
 * Amit G
 */
Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.SubstituteSessionWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.substitutesessionwindow',
	modal: true,
	autoScroll:true,
	title: getCourseTxCommonTranslation('SUBSTITUTE_SESSION'),
	maxHeight:500,
	width: '70%',
	items: [{
		xtype: 'form',
		method: 'POST',
		itemId:'substitutesessionwindowId',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
			
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype: 'hidden',
			name: 'roomId'
		},{
			xtype: 'hidden',
			name: 'optionalSession'
		},{
			xtype: 'hidden',
			name: 'whetherAttendanceToBeEntered'
		},{
			xtype: 'hidden',
			name: 'sessionPlanned'
		},{
			xtype: 'hidden',
			name: 'sessionNumber'
		},{
			xtype: 'hidden',
			name: 'cvId'
		},{
			xtype: 'hidden',
			name: 'substituteCourseId'
		},{
			xtype: 'hidden',
			name: 'substituteComponentId'
		},{
			xtype: 'hidden',
			name: 'substituteSectionId'
		},{
			xtype: 'hidden',
			name: 'substitutePeriodId'
		},{
			xtype: 'hidden',
			name: 'substituteBatchId'
		},{
			xtype: 'hidden',
			name: 'courseSectionType'
		},{
			xtype: 'hidden',
			name: 'substituteFacultyId'
		},{
        	xtype: 'datefield',
        	itemId:'substituteSessionDateId',
        	name: 'substituteSessionDate',
        	hidden:true,
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);
				}
			}
        },{
			xtype : 'timefield',
			name : 'slotFrom',		
			itemId : 'slotFrom',			
			fieldLabel:getCourseTxCommonTranslation('CVG_TIME_FROM'),
			format:'g:i A',
			vtype: 'timerange',
			endTimeField : 'slotTo',
			hidden:true
		},{
			xtype : 'timefield',
			name : 'slotTo',
			itemId : 'slotTo',	
			fieldLabel : getCourseTxCommonTranslation('CVG_TIME_TO'),
			format:'g:i A',
			vtype: 'timerange',
			startTimeField : 'slotFrom',
			hidden:true
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype:'displayfield',
				name:'sessionFrom',
				itemId:'sessionFrom',
				fieldLabel:getCourseTxCommonTranslation('SESSION_FROM')
			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			/*layout: {
				type: 'vbox'
			},*/
			defaults :{
				width: 700,
				labelAlign : 'top'
			},
			items: [{
				xtype : 'radiogroup',
				itemId : 'courseSectionTypeRadio',
				items : [{
					boxLabel : getCourseTxCommonTranslation('PROGRAM_PERIOD'),
					name : 'sectionType',
					inputValue : 'PBS',
					checked : true
				},{
					boxLabel : getCourseTxCommonTranslation('SECTION_GROUP'),
					name : 'sectionType',
					inputValue : 'CBS'
				},{
					boxLabel : getCourseTxCommonTranslation('ORGANIZATION'),
					name : 'sectionType',
					inputValue : 'ORGANIZATION'
				},{
					boxLabel : getCourseTxCommonTranslation('AL_LEVEL'),
					name : 'sectionType',
					inputValue : 'AL_LEVEL'
				}]
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype:'displayfield',
				name:'sessionDate',
				itemId:'sessionDate',
				fieldLabel:getPersonModuleTranslation('SESSION_DATE'),
				labelCls:'boldStyleOnSubSessionWin'
			},{
				xtype:'displayfield',
				name:'timeSlot',
				itemId:'timeSlot',
				fieldLabel:getProgramandcourseTranslation('TIME_SLOT'),
				labelCls:'boldStyleOnSubSessionWin'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				name: 'facultyId',
				itemId : 'facultyId',
				fieldLabel: getProgramandcourseTranslation('AVAILABLE_TEACHER'),
				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.SubstituteFacultyStore'),
	        	displayField : 'value',
	        	valueField : 'id',
	        	allowBlank:false,
				typeAhead:true,
				forceSelection:true,
				minChars:3,
				queryParam:'name',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'courseVariant',
				itemId : 'courseVariant',
				fieldLabel: getProgramandcourseTranslation('COURSE_VARIANT'),
				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.SubstituteCourseVariantStore'),
	        	displayField : 'value',
	        	valueField : 'id',
				allowBlank: false,
				disabled:true
			},{
				xtype: 'customcombobox',
				name: 'room',
				itemId : 'room',
				fieldLabel: getCommonTranslation('ROOM'),
				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoomStore'),
				//store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.NewClassRoomStore'),
				
				displayField:'code',
				valueField:'id',
				allowBlank: false,
				queryMode:'local'
			},
			{
				xtype: 'multiselectcombofield',
				name: 'topicId',
				itemId : 'topicId',
				autoloadStore: false,
				width: 226,
				fieldLabel: getCommonTranslation('TOPIC'),
				store : 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.TopicByCourseId',
				displayField: 'value',
				valueField: 'id',	
				allowBlank: false,
				disabled:true,
				typeAhead:true,
				
				
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textarea',
				name:'reasonForSubstitution',
				itemId:'reasonForSubstitution',
				width: 460,
				maxLength : 255,
				fieldLabel: getCourseTxCommonTranslation('REASON_FOR_SUBSTITUTION'),
				allowBlank:false
			}]
		}, {
			xtype: 'fieldcontainer',
			width: '100%',
			items: [{
				xtype: 'button',
				text: getCourseTxCommonTranslation('SUBSTITUTE'),
				itemId: 'substituteBtn',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}]
		}]
	}]
});