/**
 * Dharmendra.prajapati
 */
Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.mastertimetable.MasterTimeTableDetailedWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.mastertimetabledetailedwindow',
	title:getProgramandcourseTranslation('ADD_SCHEDULE'),
	modal:true,
	//height: '55%',
	height: 400,
	width: '73%',
    autoScroll: false,
    layout: 'fit',
    //overflowX: false,
    items: [{
		xtype: 'idgeneratorformwin',
		width:'auto',
        //margin: 0,
        layout: {
            type: 'vbox'
        },
        defaults: {
            labelAlign: 'top'
        },
        autoScroll: true,
        overflowX: false,
        standardSubmit: false,
        plugins:"formlabelrequired",
		items: [{
			xtype:'hidden',
			name:'homeRoomId'
		},{
			xtype:'hidden',
			name:'courseVariantId'
		},{
			xtype:'hidden',
			name:'academicTermId'
		},{
			xtype:'fieldcontainer',
			layout : 'vbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype:'displayfield',
				name : 'courseName',
				itemId : 'courseName',
				fieldLabel: getProgramandcourseTranslation('COURSE'),
				hidden:true
			}]
		},{
			 xtype : 'fieldcontainer',
	       	 layout : 'hbox',
	       	 defaults : {
	       		 labelAlign : 'top',
	       		 width:260
	       	 },
	       	 layout : {
	       		 type : 'hbox'
	       	 },
			 items:[{
				xtype: 'customcombobox',
				name: 'variant',
				itemId: 'variantId',
				fieldLabel:  getProgramandcourseTranslation('COURSE_VARIANT'),
				store:'coursetransaction.sectioncoursecoverageplan.mastertimetable.VariantBySection',
				displayField:'code',
				valueField:'id',
				allowBlank:false,
				typeAhead:true,
				forceSelection:true
			 }]},
			 {
			 xtype : 'fieldcontainer',
	       	 layout : 'hbox',
	       	 defaults : {
	       		 labelAlign : 'top',
	       		 width:260
	       	 },
	       	 layout : {
	       		 type : 'hbox'
	       	 },
			 items:[{
      			    xtype:'checkbox',
    			    name: 'allFacultyCheck',
    			    boxLabel: getCommonTranslation('ALL_FACULTY_CHECK'),
    			    itemId:'allFacultyCheckId',
    			    inputValue: true,
    				uncheckedValue: false,
    				//disabled:true,
        			//cls: 'checkBoxEllipsisCls',
        			listeners:{
        				change: function(cmb){
        				
        					var facultyField = this.up('form').down('#facultyId');
        					
        					
        					var variantField = this.up('form').down('#variantId');

        					if(variantField.isVisible()){
        						var variantId = variantField.getValue();
                            }
                            else{
                                try{
                                    var variantId = Ext.ComponentQuery.query('mastersearchfilter')[0].getForm().getValues().courseVariantId;
                                }
                                catch(e){
                                    var variantId = '';
                                    //--
                                }
                            }
        					
        					if(cmb.getValue() == true){
        						var facultyStore = Ext.create('Academia.store.coursetransaction.homework.assignmentdetails.Faculty',{
	        						proxy : {
										type : 'rest',
										api:{
											read:SERVERURL.PATH_FIND_STAFF_BY_AL_ID
										},
										reader: {
											type: 'json'
										},
										extraParams: {
		        							id: this$.getCurrentAcademyLocation()
		        						}	
									}
	        					});
	        					
        					}
        					else{
        						var facultyStore = Ext.create('Academia.store.coursetransaction.homework.assignmentdetails.Faculty',{
	        						proxy : {
										type : 'rest',
										api:{
											read:SERVERURL.HW_ASSIGN_FACULTY
										},
										reader: {
											type: 'json'
										},
										extraParams: {
		        							courseVariantId: variantId
		        						}	
									}
	        					});
        					}
        					
        					var cFields = Ext.ComponentQuery.query('mastertimetabledetailedwindow [name=faculty]');

                            Ext.each(cFields, function(facultyField){
                            	facultyField.bindStore(facultyStore);
                            	var facultyId = facultyField.value;
                            	if(!facultyField.isDisabled()){
                            		facultyStore.load({
	    	                			 callback: function(records, operation, success) {
	    	                				 if (success) {
	    	                					 for(var i in records){
	                    	 							if(records[i].data.id==facultyId){
	                    	 								facultyField.setValue(records[i].data.id);
	                    	 							}
	                    	 						}
	    	                				 }
	    	                			 }
	    	                		 });
            					}
                            });
        				}
        			}
  		      }]
		},{
			xtype:'panel',
			itemId:'panelId',
			layout : 'vbox',
			style:{
				marginLeft:'0px',
				marginTop:'0px'
			},
			items:[{
			 xtype : 'fieldcontainer',
	       	 layout : 'hbox',
	       	 defaults : {
	       		 labelAlign : 'top',
	       		 width:226
	       	 },
	       	 layout : {
	       		 type : 'hbox'
	       	 },
			 items:[{
				 xtype: 'customcombobox',
				 name: 'faculty',
				 itemId: 'facultyId',
				 fieldLabel: getCourseTxCommonTranslation('FACULTY'),
				 store:Ext.create('Academia.store.coursetransaction.homework.assignmentdetails.Faculty'),
				 displayField:'value',
				 valueField:'id',
				 allowBlank:false,
				 disabled:true,
				 typeAhead:true,
				 forceSelection:true
			 },{
				xtype: 'customcombobox',
				name: 'weekDay',
				itemId: 'weekDayId',
				fieldLabel: getProgramandcourseTranslation('WEEKDAY'),
				store:'coursetransaction.sectioncoursecoverageplan.mastertimetable.WorkingWeekday',
				displayField:'value',
				valueField:'id',
				allowBlank:false,
				disabled:true,
				typeAhead:true,
				forceSelection:true
			 },{
				xtype: 'customcombobox',
				name: 'cycleWeekDay',
				itemId: 'cycleWeekDayId',
				fieldLabel: getCommonTranslation('DAY'),
				store:'coursetransaction.sectioncoursecoverageplan.mastertimetable.CycleWorkingDays',
				displayField:'value',
				valueField:'id',
				allowBlank:false,
				typeAhead:true,
				forceSelection:true,
				hidden:true
			 },{
				 xtype: 'customcombobox',
				 name: 'periodTimings',
				 itemId: 'periodTimingsId',
				 fieldLabel: getProgramandcourseTranslation('TIMESLOT'),
				 store:'coursetransaction.sectioncoursecoverageplan.mastertimetable.PeriodsByCalendar',
				 displayField:'periodTimings',
				 valueField:'calendarSlotId',
				 queryMode:'local',
				 allowBlank:false,
				 disabled:true,
				 typeAhead:true,
				 forceSelection:true,
				 listeners:{
					 select:function(obj,rec,value){
						 var nxtSib = obj.nextSibling();
						 nxtSib.setDisabled(false);
						 var roomStore = obj.nextSibling().getStore();

						 var form = obj.up('form').getForm();
						 var courseVariantId = form.findField('variant').getValue();
						 var academicTermId = form.findField('academicTermId').getValue()
						 if(isNullOrEmpty(courseVariantId)) {
							 courseVariantId = form.findField('courseVariantId').getValue()
						 }
						 var homeRoomId = form.findField('homeRoomId').getValue(); 
						 /*roomStore.getProxy().extraParams = {
							 calendarSlotId: rec[0].data.calendarSlotId
  					   };
					   roomStore.load();*/

						 obj.nextSibling().clearValue();
						 
						 obj.nextSibling().getStore().getProxy().extraParams = {
							 calendarSlotId: rec[0].data.calendarSlotId,
							 courseVariantId:courseVariantId,
							 academicTermId:academicTermId
	                	   };
						 
						 obj.nextSibling().getStore().load({
//							 params:{
//								 calendarSlotId: rec[0].data.calendarSlotId,
//							 },
							 callback: function(records, operation, success) {
								 if (success) {
									 if(records.length > 0){
										 for(var i in records){
											 if(homeRoomId == records[i].data.id){
												 obj.nextSibling().setValue(records[i].data.id);
												 if(form.isValid()){
                                                     obj.up('form').down('#SubmitBtn').setDisabled(false);
                                                 }	 
											 }
										 }
									 }

								 }
							 }

						 });

					 }
	  			   }
			 },{
				 xtype: 'customcombobox',
				 name: 'room',
				 itemId:'roomId',
				 fieldLabel: getCourseTxCommonTranslation('CVG_ROOM'),
				 store:'coursetransaction.sectioncoursecoverageplan.mastertimetable.RoomByCalendar',
				 displayField:'value',
				 valueField:'id',
				 allowBlank:false,
				 disabled:true,
				 typeAhead:true,
				 forceSelection:true,
				 editable:false
			 },{
				 xtype: 'button',
				 itemId: 'detailedBtn',
				 width: 'auto',
				 cls: 'CustomBodyBtnSettings',
				 width: 'auto',
				 text: getCommonTranslation('ADDBUTTONTEXT'),
				 tooltip: getCommonTranslation('ADD'),
				 style:{
					 marginTop:'30px'
				 },
				 listeners:{
     				click:function(obj){
     					var form = obj.up('form');
     					form.down('#SubmitBtn').setDisabled(true);
     				}
     			}
     		}]
		}
	]},{
			xtype:'fieldcontainer',
			cls:'windowBtnPos',	
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCourseTxCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	  }]     
});
