/**
 * @author Rajkumar.patidar
 */

Ext.define('Academia.view.coursetransaction.sectionmanagement.SectionForProgramsWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.sectionforprogramswin',
	autoScroll: true,
	title:getCourseTxCommonTranslation('ASSIGN_SECTION'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	closeAction: 'destroy',
	items: [{
		xtype: 'form',
		bodyPadding: '5 5 5 5',
		margin: 0,
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:'auto'
		},
		standardSubmit: false,
		items: [{
					xtype: 'hidden',
					name: 'id'
				},{
					xtype : 'fieldcontainer',
					layout : 'hbox',
					defaults : {
						labelAlign: 'top',
						 width:226
			       	 },
					items:[{
						xtype:'displayfield',
						name : 'program',
						fieldLabel: getCourseTxCommonTranslation('PROGRAM'),
						hidden:true
					},{
						xtype:'displayfield',
						name : 'batch',
						fieldLabel: getCourseTxCommonTranslation('BATCH'),
						hidden:true
					}]
				},{
					xtype:'displayfield',
					name : 'period',
					fieldLabel: getCourseTxCommonTranslation('PERIOD'),
					hidden:true
				},{
					xtype : 'fieldcontainer',
					layout : 'hbox',
					defaults : {
						labelAlign: 'top',
						 width:226
			       	 },
					items:[{
					xtype: 'customcombobox',
					name:'sectionId',
					itemId: 'sectionId',
				    store:'coursetransaction.sectionmanagement.SectionsStore',
				    fieldLabel: getCourseTxCommonTranslation('SECTION_OR_SECTION_GROUP'),
					displayField: 'value',
					valueField: 'id',
					typeAhead:true,
					forceSelection:true,
					allowBlank:false
				},{
					xtype : 'datefield',
					anchor : '100%',
					fieldLabel : getCourseTxCommonTranslation('TRANSFER_DATE'),
					name : 'transferDate',
					itemId : 'transferDate',
					//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype : 'daterange',
					allowBlank:false,
//					value: new Date(),
					listeners: {
						render: function(obj) {
							obj = dateFormatRender(obj);						
							obj.setValue(new Date());
						//	obj.setMaxValue(new Date());
						}
					}
				}]},{
					xtype: 'textareafield',
					name: 'sectionRule',
					itemId: 'sectionRuleId',
					width: 460,
					fieldLabel: getCourseTxCommonTranslation('REMARKS')
		
		},{
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'hbox',
            defaults: {
                width: 300,
                labelAlign: 'top'
            },
            items: [{
		            xtype: 'checkboxfield',
		            labelAlign: 'right',
		            itemId:'whetherRetainDataId',
		            boxLabel: getCommonTranslation('DO_YOU_WANT_TO_RETAIN_THE_DATA'),
		            name: 'whetherRetainData',
		            inputValue : true,
		            uncheckedValue: false 
		        }]
        	}
	       	 ,{	
			layout: {
				type: 'hbox'
			},
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCourseTxCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'submitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			  },{
				xtype: 'button',
				text: getCourseTxCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	  }]     
});