/**
 * @author Dharmendra.Prajapati
 * @author seshagiri.k 
 */
Ext.define('Academia.view.coursetransaction.studentcourseenrollment.CourseEnrollmentSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.courseenrollmentsearch',
	plugins : "formlabelrequired",
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    items: [{
        /*xtype: 'form',
        width: '100%',
        items: [{*/
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
			items :[{
						xtype: 'customcombobox',
						fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
						itemId: 'programId',
						name: 'PROGRAM_ID',
						store:'program.ProgramCodeOrNameSmartSearch',
						displayField:'valueCode',
						valueField: 'id',
						queryParam:'qry',
		    			minChars:3,
						//allowBlank:false,
						typeAhead:true,
						//forceSelection:true,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						//forceSelection:true,
		    			  listConfig: {
		    				  listeners: {
		    						beforeshow: function(picker) {
		    							picker.minWidth = picker.up('combobox').getSize().width;
		    						}
		    					},
		    	                loadingText: getCommonTranslation('SEARCHING'),
		    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    	                getInnerTpl: function() {
		    	                    return '<div class="search-item">' +
		    	                        '{code} / {value}'+ 
		    	                    '</div>';
		    	                }
		    	            }
					},{
						 xtype: 'customcombobox',
						 fieldLabel: getCourseTxCommonTranslation('BATCH'),
						 itemId:'batchId',
						 name: 'PROGRAM_BATCH_ID',
						 store: 'enquiry.AcademicBatchStore',
						 valueField: 'id',
						 displayField: 'value',
						 //allowBlank:false,
						 typeAhead:true,
						 //forceSelection:true,		
						 disabled:true
					},{
						xtype: 'customcombobox',
						fieldLabel: getCourseTxCommonTranslation('PERIOD'),
						itemId:'periodId',
						name: 'PROGRAM_BATCH_PERIOD_CONFIG_ID',
						store: 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
						valueField: 'id',
						displayField: 'value',
						allowBlank:true,
						typeAhead:true,
						forceSelection:true	 ,
						disabled:true
					}]
				},{
				    xtype: 'fieldcontainer',
		            width: 'auto',
		            layout: 'hbox',
		            defaults: {
		                width: 226,
		                labelAlign: 'top'
		            },
					items : [{
						xtype: 'customcombobox',
						fieldLabel: getCourseTxCommonTranslation('COURSE'),
						itemId: 'courseCodeId',
						name: 'COURSE_ID',
						store:'coursetransaction.studentenrollment.enrollmentmaster.CourseEnrollmentCombo',
						valueField:'id',
						displayField:'valueCode',
						allowBlank:true,
						disabled:true,
						queryParam:'name',
		    			minChars:3,
						typeAhead:true,
						forceSelection:true,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						forceSelection:true,
		    			  listConfig: {
		    	                loadingText: getCommonTranslation('SEARCHING'),
		    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    	                getInnerTpl: function() {
		    	                    return '<div class="search-item">' +
		    	                        '{code} / {value}'+ 
		    	                    '</div>';
		    	                }
		    	            }
					},{
						xtype: 'customcombobox',
						fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
						name:'COURSE_VARIENT_ID',
						itemId: 'courseVariantId',
					    store:'coursetransaction.sectionmanagement.CoruseVariantSectionStore',
						displayField: 'code',
						valueField: 'id',
						typeAhead:true,
						forceSelection:true,
						allowBlank:true,
						disabled:true
					},{
						xtype: 'customcombobox',
						fieldLabel: getCommonTranslation('COURSE_TYPE'),
						itemId:'courseType',
						name: 'COURSE_TYPE_ID',
						store: 'common.OptionMandatoryStore',
						valueField: 'id',
						displayField: 'value',
						allowBlank:true,
						typeAhead:true
					}]
				},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype : 'customcombobox',
						fieldLabel : getCommonTranslation('INTAKE_YEAR'),
						name : 'intakeYear',
						itemId : 'intakeYear',
						displayField:'value',
						valueField:'id',
						width:226,
						typeAhead:true,
						forceSelection:true,
						minChars:3,
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{code}'  +
								'</div>';
							}
						},
						listeners  :{
							render : function(combo){
								var store=Ext.create('Academia.store.common.IntakeYearStore');
								combo.bindStore(store)
							}
						}
					},{
						xtype : 'customcombobox',
						fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
						name : 'academicTerm',
						itemId : 'academicTerm',
						displayField : 'value',
						valueField : 'id',
						typeAhead : true,
						forceSelection : true,
						hidden : false,
						listeners  :{
							render : function(combo){
								var store=Ext.create('Academia.store.common.AcademicTermStore');
								combo.bindStore(store)
							}
						}
					},{
						xtype: 'customcombobox',
						name: 'facultyName',
						itemId: 'facultyItemId',
						store:'coursetransaction.facultytopicassignment.AssignFacultyStore',
						fieldLabel:getExaminationTranslation('FACULTY'),
						valueField: 'id',
						displayField: 'value',
						queryParam:'codeOrName',
						minChars:3,
						width:226,
						typeAhead:false,
						triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
						hideTrigger:true,
						enableKeyEvents  : 'true',
						forceSelection : true,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						listConfig: {
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}' +
								'</div>';
							},
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
						}
					}]
				},{
		            xtype: 'checkboxfield',
		            width: 'auto',
		            labelAlign: 'right',
		            itemId:'nonParamCourses',
		            name: 'nonParamCourses',
		            boxLabel: getCommonTranslation('VIEW_NON_PARAM_COURSE'),
		            inputValue : true,
		            uncheckedValue: false,
//		            style:{
//                    	marginTop:'28px'
//                    }
		        },{
		            xtype: 'fieldcontainer',
		            width: 'auto',
		            
		            items: [{
		                xtype: 'button',
		                text: getCommonTranslation('SEARCH'),
		                itemId: 'studentCourseEnrollSearchBtn',
		                buttonAlign: 'left',
		                formBind:true,
		                ui: 'CustomBtnSubmit',
		                scale: CONSTANTS.BUTTONSIZE
		            },{
		                xtype: 'button',
		                text: getCourseTxCommonTranslation('RESET'),
		                itemId: 'resetButton',
		                buttonAlign: 'left',
		                ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
		            }]
		        }]
    	//}]
});