Ext.define('Academia.view.coursetransaction.studentcourseenrollment.enrollmenttabstructure.studentlist.RequestReceivedStudentList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias : 'widget.requestreceivedstudentlist',
    title: getCommonTranslation('LIST_OF_REQUEST_RECEIVED_STUDENT'),
    store : 'coursetransaction.studentenrollment.enrollmentmaster.RequestReceivedGrid',
    border: true,
    viewConfig : {
	stripeRows : CONSTANTS.STRIPEROWS
    },
    dockedItems : [ {
	xtype : 'toolbar',
	dock : 'bottom',
	items : [ {
	    xtype: 'custompagingtoolbar',
        plugins:['pagesize'],
	    store : 'coursetransaction.studentenrollment.enrollmentmaster.RequestReceivedGrid',
	    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
	    displayInfo : true
	}]
    }
    ],
    initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
    columns : [ {
    	header: getCourseTxCommonTranslation('SELECT'),
        dataIndex: "status",
        itemId:'checkboxHeaderItemId',
        flex : 1,
        renderer:function(value){
        	if(value=='Pending'){
        		return Ext.String.format("<input type='checkbox' name='rowSel' value='checkbox'/>");
        	}else if(value=='Enrolled') {
        		return Ext.String.format("<input type='checkbox' name='rowSel' value='checkbox' checked disabled/>");
        	}else if(value=='Rejected' || value=='De-Enrolled' ) {
        		return Ext.String.format("<input type='checkbox' name='rowSel' value='checkbox' disabled/>");
        	}
        }
     }, {
		    header : getCommonTranslation('STUDENT_ID'),
		    dataIndex : 'studentCode',
		    flex:1
		  
	},{
	    header : getCourseTxCommonTranslation('ADMISSION_CODE'),
	    dataIndex : 'admissionCode',
	    flex : 1,
	    sortable : true
	},{
	    header : getCourseTxCommonTranslation('STUDENT_NAME'),
	    dataIndex : 'studentName',
	    flex : 1,
	    sortable : true
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex:1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex:1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex:1,
		hidden :true
	},{
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        sortable:true,
	    flex : 1,
        hidden:true
    },{
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        sortable: true,
	    flex : 1,
        hidden:true
    },{
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'periodName',
        sortable:true,
	    flex : 1,
        hidden:true
    },{
	    header : getCourseTxCommonTranslation('SECTION'),
	    dataIndex : 'section',
	    flex : 1,
	    sortable : true
	},{
	    header :getCourseTxCommonTranslation('STATUS') ,
	    dataIndex : 'status',
	    flex : 1,
	    sortable : true
	}  
	]

});
 