/*
 * @author Dharmendra.Prajapati 
 */
Ext.define('Academia.view.coursetransaction.studentcourseenrollment.enrollmenttabstructure.studentlist.StudentsSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentssearch',
//	title : getCommonTranslation('QUICK_SEARCH'),
//	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	layout : {
		type: 'anchor',
		layout: 'hbox'
	},
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width:226
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'hidden',
		name:'id'
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
			type : 'hbox'
				},
			defaults : {
					width : 226,
					labelAlign : 'top'
				},
			items : [
				{
					xtype:'customcombobox',
					name:'admissionNo',
					fieldLabel:getCourseTxCommonTranslation('ADMISSION_NO'),
					store:'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameOrAdmissionCodeSmartSearch',
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'name',
					minChars:3,
					typeAhead:false,
		            hideTrigger:true,
		            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		            triggerAction: '',
		            forceSelection:true,
					  listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{code} / {value}'  +
			                    '</div>';
			                }
			            }
				},{
					xtype:'customcombobox',
					//xtype:'textfield',
					name:'studentName',
					fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
					store: 'feeandpayment.managebill.Student',
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'studentNameOrCode',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					typeAhead:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					hideTrigger:false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{studentCode} / {studentName}' +
							'</div>';
						}
					}
				},{
					 xtype: 'customcombobox',
					 name: 'status',
					 itemId:'status',
					 fieldLabel:getCourseTxCommonTranslation('SELECT_STATUS'),
					 store: 'coursetransaction.studentenrollment.enrollmentmaster.EnrollmentStatusCombo',
					 valueField: 'value',
					 displayField: 'value',
					 editable:false,
					 typeAhead:true,
					 forceSelection:true
					 
				}]
				   	},
				   	{
			            xtype: 'fieldcontainer',
			            width: 'auto',
			            
			            items: [{
							 xtype: 'button',
					         text: getCourseTxCommonTranslation('SEARCH'),
					         itemId: 'searchButton_Request',
					         ui: 'CustomBtnSubmit',	
					         scale: CONSTANTS.BUTTONSIZE
						},{
			                xtype: 'button',
			                text: getCourseTxCommonTranslation('RESET'),
			                itemId: 'resetBtn',
			                buttonAlign: 'left',
			                ui: 'CustomBtnCancel',
			                scale: CONSTANTS.BUTTONSIZE
			            }]
			        }
	]
});