/**
 * @author Abhishek.Bais
 * 
 */
Ext.define('Academia.view.coursetransaction.studentcourseenrollment.studentcourseregistrationrevamp.CBSEnrolledProgramFilter', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.cbsenrolledprogramfilter',
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items :[{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			itemId: 'enrolledprogramId',
			name: 'PROGRAM_ID',
			store:'program.ProgramsAssociatedWithCourseVariantOfEnrolledStudent',
			displayField:'valueCode',
			valueField: 'id',
			queryParam:'qry',
			minChars:3,
			allowBlank:false,
			typeAhead:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('BATCH'),
			itemId:'enrolledbatchId',
			name: 'PROGRAM_BATCH_ID',
			store: 'enquiry.EnrollStudentBatchStore',
			valueField: 'id',
			displayField: 'value',
			allowBlank:false,
			typeAhead:true,
			disabled:true
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items : [{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('PERIOD'),
			itemId:'enrolledperiodId',
			name: 'PROGRAM_BATCH_PERIOD_CONFIG_ID',
			store: 'program.programDetails.programBatches.courseParameter.EnrollmentProgramCoursePeriod',
			valueField: 'id',
			displayField: 'value',
			allowBlank:true,
			typeAhead:true,
			forceSelection:true	 ,
			disabled:true
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION'),
			width: 226,
			labelAlign: 'top',
			name : 'PROGRAM_BATCH_SECTION_ID',
			itemId : 'enrolledprogram_Batch_Section_Config_ID',
			store:'attendance.SectionOfEnrollmentStudentByPeriodID',
			displayField : 'sectionCode',
			valueField : 'sectionId',
			typeAhead : true,
			disabled:true,
			forceSelection : true
		}]
		},
	{
		xtype: 'fieldcontainer',
		width: 'auto',

		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'studentCourseEnrolledSectionSearchBtn',
			buttonAlign: 'left',
			formBind:true,
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetcbsenrolledButton',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
//}]
});