	/**
	 * @author kamlesh chilhate
	 */
	
	Ext.define('Academia.view.coursetransaction.studentcourseenrollment.studentenrollmentdetail.ChangeExamCenterGrid', {
		extend: 'Ext.grid.Panel',
		alias: 'widget.changeexamcentergrid',
		itemId: 'changeexamcenterwin',
		store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentPortalEnrollmentDetail2',
		frame: false,
		border: true,
		title: getCommonTranslation('CHANGE_EXAM_CENTER'),
		autoScroll: true,
		isGridConfigurable: true,
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		selType: 'checkboxmodel',
		selModel: {
		    mode: 'MULTI',
		    showHeaderCheckbox: false,
		    allowDeselect: false,
		    checkOnly: true
		},
		cls: 'changeExamCenterGridCls',
		tbar: [{
			xtype: 'button',
			text: getCommonTranslation('SAVE'),
			itemId: 'submitBtn'
		}, {
			xtype: 'displayfield',
			name: 'saveEnrollmentMsg',
			itemId: 'saveEnrollmentMsgId',
			hidden: true
		}],
		columns: [{
			header: getCommonTranslation('COURSE_CODE_NAME'),
			dataIndex: 'courseCode',
			flex: .2,
			sortable: true
		}, {
			header: getCourseTxCommonTranslation('TYPE'),
			dataIndex: 'whetherOptional',
			flex: .1,
			renderer: function(val, metaData, record) {
				if (!val) {
					return getCourseTxCommonTranslation('MANDATORY');
				} else if (val) {
					return getCourseTxCommonTranslation('OPTIONAL');
				}
	
			}
		}, {
			header: getCommonTranslation('COURSE_VARIANT'),
			dataIndex: 'courseVariantId',
			flex: .1,
			editor: {
				xtype: 'customcombobox',
				name: 'courseVariant_Name',
				store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentPortalEnrollmentDetail3',
				valueField: 'variantId',
				displayField: 'variantCode',
				typeAhead: false
			},
			renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
				var grid = view;
				var $this = this;
				var store = grid.getStore();
				var models = grid.getStore().getRange();
	
				for (var j = 0; j < record.data.variantList.length; j++) {
					var variant = record.data.variantList[j];
					if (variant.whetherApproved && variant.whetherRequested) {
						rec.tdCls = "comboboxdisable";
					}	
				}
				if ((val == '' || val == undefined)) {
					var variantCode = record.data.variantCode;
					if (variantCode != '' && variantCode != null) {
						return variantCode;
					} else {
						rec.tdCls = 'gridInputCustomStyle';
						return getExaminationTranslation('SELECT_VARIANT');
					}
				} else if (val != '' && val != undefined) {
					var grid = view.up();
					var ddlRecord = grid.getMlpData();
					for (var i in ddlRecord) {
						if (val == ddlRecord[i].data.variantId) {
							models[rowIndex].set("variantCode", "" + ddlRecord[i].data.variantCode);
							models[rowIndex].set("courseVariantId", ddlRecord[i].data.variantId);
						}
					}
					return record.data.variantCode;
				} else {
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('SELECT_VARIANT');
				}
	
			}
		}, {
			header: getCommonTranslation('EXAM_CENTER'),
			dataIndex: 'examCenterId',
			flex: .1,
			editor: {
				xtype: 'customcombobox',
				itemId: 'examCenterId',
				name: 'examCenterId',
				store: Ext.create('Academia.store.enquiry.ExamCenterCSMStore'),
				valueField: 'id',
				displayField: 'value',
				forceSelection: true,
				editable: false,
				typeAhead: false,
				listeners: {
					select: function(combo) {
						var grid = combo.up('grid');
						try {
							var record = combo.up().editingPlugin.context.record;
							record.data.examCenterId = combo.getValue();
							record.data.examCenterName = combo.getDisplayValue();
							grid.getView().refresh();
						}
						catch (e) { }
					}
				}
			}, renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
				var examCenterName = record.data.examCenterName;
				if (examCenterName != '' && examCenterName != null) {
					return examCenterName;
				} else {
					rec.tdCls = 'gridInputCustomStyle';
					return getCommonTranslation('SELECT_EXAM_CENTER');
				}
			}
		}, {
			header: getCommonTranslation('COURSE_STATUS'),
			dataIndex: 'courseStatus',
			flex: .05,
			editor: {
				xtype: 'customcombobox',
				itemId: 'courseEnrollmentStatusId',
				name: 'courseEnrollmentStatusId',
				store: Ext.create('Academia.store.common.ChangeEnrollmentMasterCourseStatusStore'),					
				valueField: 'value',
				displayField: 'value',
				forceSelection: true,
				editable: false,
				typeAhead: false,
				
			}, renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
				var courseStatus = record.data.courseStatus;
				if (courseStatus != '' && courseStatus != null) {
					return courseStatus;
				} else {
					rec.tdCls = 'gridInputCustomStyle';
					return getCommonTranslation('SELECT_COURSE_ENROLLMENT_STATUS');
				}
			}
		}],
		plugins: [{
		        ptype: 'cellediting',
		        clicksToEdit: 1,
		        listeners: {
		            beforeedit: function(editor, context) {
		            	 if(editor.context.field=='courseStatus'){
							var combo = context.column.getEditor(); // Access the editor's field (the combo box)
					        var store = combo.getStore(); // Get the store of the combo box
					
					        if (store) {
					            var enrollCourseStatus = context.record.get('courseStatus');
								if(isNullOrEmpty(enrollCourseStatus))
								enrollCourseStatus=context.record.get('enrolledCourseStatus');
					           
					
					            // Set extra parameters on the store's proxy
					            store.getProxy().extraParams = {
					                fromStatus: enrollCourseStatus,
					                isCurrentAcademicTerm: true
					            };
					        }
			               
			                    store.load();
				         		}
				        	},canceledit: function(editor, context) {
					           var enrollCourseStatus = context.record.get('enrollCourseStatus');
					            var enrolledCourseStatus = context.record.get('enrolledCourseStatus');
					
					            if (isNullOrEmpty(enrollCourseStatus) && !isNullOrEmpty(enrolledCourseStatus)) {
					                context.record.set('enrollCourseStatus', enrolledCourseStatus);
					            }
					        },edit: function(editor, context) {
					           var enrollCourseStatus = context.record.get('enrollCourseStatus');
					            var enrolledCourseStatus = context.record.get('enrolledCourseStatus');
					
					            if (isNullOrEmpty(enrollCourseStatus) && !isNullOrEmpty(enrolledCourseStatus)) {
					                context.record.set('enrollCourseStatus', enrolledCourseStatus);
					            }
					        }
				        }
		    }]
	});