Ext.define('Academia.view.coursetransaction.studymaterialdistributionnew.StudentSmdGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentsmdgrid',
	store : 'coursetransaction.studymaterialdistributionnew.StudentSmdStr',
	title: getCommonTranslation('LIST_OF_COURSE_READING_MATERIAL'),
	border: true,
	refreshStoreData:true,
	selType:'checkboxmodel',
	selModel: {
		 showHeaderCheckbox: true,
		 allowDeselect: true,
		 checkOnly : true,
		 mode : 'MULTI'
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
		      itemId: 'custompagingtoolbarstudentsmd',
	            plugins:['pagesize'],
			store : 'coursetransaction.studymaterialdistributionnew.StudentSmdStr',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	tbar: [{
        xtype: 'button',
        text:getCourseTxCommonTranslation('SENT_MATERIAL'),
        itemId: 'btnAddSentMaterial'
    },{
        xtype: 'button',
        text:getCourseTxCommonTranslation('DISPATCH_FORM'),
        itemId: 'printDispatchForm',
    }],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	columns : [{
		header :getCourseTxCommonTranslation('COURSE_NAME'),
		dataIndex : 'courseName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariant',
		flex:1
	},{
		header : getCourseTxCommonTranslation('READING_TYPE'),
		dataIndex : 'readingType',
		flex:1
	},{
		header : getCourseTxCommonTranslation('READING_NAME'),
		dataIndex : 'readingName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('AUTHOR'),
		dataIndex : 'author',
		flex:1
	},{
		header : getCourseTxCommonTranslation('PUBLISHER'),
		dataIndex : 'publisher',
		flex:1
	},{
		header : getCourseTxCommonTranslation('INVENTORY_STATUS'),
		dataIndex : 'isInStock',
		flex:1,
		renderer : function(value) {
			if (value) {
				return value = getCourseTxCommonTranslation('IN_STOCK');
			} else {
				return value = getCourseTxCommonTranslation('NOT_IN_STOCK');
			}
		}
	},{
		header : getCourseTxCommonTranslation('STATUS'),
		dataIndex : 'updateFlag',
		flex:1,
		renderer : function(value) {
			if (value) {
				return value = getCourseTxCommonTranslation('MATERIAL_STATUS');
			} else {
				return "";
			}
		}
	}]
});
