/**
 * @author Akshay Sharma
 * 
 */
Ext.define('Academia.view.coursetransaction.viewschedule.ViewScheduleSearch',{
	extend: 'Ext.form.Panel',
	alias : 'widget.viewschedulesearch',
	plugins : "formlabelrequired",
	autoScroll : false,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype : 'form',
		width : '100%',
		items : [{
			xtype : 'radiogroup',
			name:'courseSectionRadio',
			itemId : 'courseSectionRadio_Id',
			labelAlign : 'top',
			fieldLabel:getProgramandcourseTranslation('VIEW_SCHEDULE_FOR'),
			defaults: {
				flex: 1
			},
			items : [{
				boxLabel : getCourseTxCommonTranslation('PROGRAM_BATCH_SECTION'),
				name : 'sectionCourse',
				inputValue : 'programBatchSection',
				checked : true
			},{
				boxLabel : getCourseTxCommonTranslation('COURSE_SECTION'),
				name : 'sectionCourse',
				inputValue : 'courseSection'

			},{
				boxLabel : getCourseTxCommonTranslation('SECTION_GROUP'),
				name : 'sectionCourse',
				inputValue : 'sectionGroup'

			},{
				boxLabel : getProgramandcourseTranslation('FACULTY'),
				name : 'sectionCourse',
				inputValue : 'faculty'
			},{
				boxLabel : getProgramandcourseTranslation('STUDENT'),
				name : 'sectionCourse',
				inputValue : 'student'
			},{
				boxLabel : getCommonTranslation('ROOM'),
				name : 'sectionCourse',
				inputValue : 'room'
			}]
		},{
			xtype:'hidden',
			name:'courseVariantId'
		},{
			xtype:'hidden',
			name:'scheduleFor',
			value:'programBatchSection'
		},{
			xtype:'hidden',
			name:'courseVariantPBS'
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getEnquiryTranslation('INTAKE_YEAR'),
				name : 'intakeYear',
				itemId : 'intakeYear',
				displayField:'value',
				valueField:'id',
				hidden : true,
				store:'Academia.store.common.IntakeYearStore'
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'COURSE_ACADEMIC_TERM',
				itemId : 'courseAcademicTerm',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
//				hidden : true,
				allowBlank : false,
				store:'Academia.store.common.AcademicTermStore',
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				name : 'studentProgramId',
				itemId : 'student_program_Id',
				store : 'common.AssignedProgramStore',
				displayField : 'code',
				valueField : 'id',
				typeAhead : false,
				forceSelection : true,
				hidden : true,
				triggerAction: 'all',
	    	    queryParam:'name',
	            minChars:3,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		            }
			
			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			itemId:'fieldcontainerCourseAndSectionId',
			hidden:false,
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel :  getCommonTranslation('COURSE_CODE_NAME'),
				name : 'course',
				itemId : 'course_Id',
				store : 'course.AssignedPeriodCoursesFacultyStore',
				displayField : 'courseCodeName',
				valueField : 'courseId',
				typeAhead : false,
				forceSelection : true,
				hidden : true,
				disabled : true,
				triggerAction: 'all',
				queryParam:'name',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('SECTION'),
				name : 'section',
				itemId : 'courseSection_Id',
				store : 'attendance.SectionByCourseNComponent',
				displayField : 'sectionCode',
				valueField : 'sectionId',
				typeAhead : true,
				forceSelection : true,
				disabled:true,
				hidden : true
			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			itemId:'fieldcontainerAcademicTermAndProgramAndBatchId',
			hidden:false,
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'PROGRAM_ACADEMIC_TERM',
				itemId : 'programAcademicTerm',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : false,
				store:'Academia.store.common.AcademicTermStore',
			}, {
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				name : 'program',
				itemId : 'program_Id',
				store : 'common.AssignedProgramStore',
				displayField : 'code',
				valueField : 'id',
				typeAhead : false,
				forceSelection : true,
				disabled : true,
				triggerAction: 'all',
				queryParam:'name',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				name : 'batch',
				itemId : 'batch_Id',
				store : 'enquiry.AcademicBatchStore',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				disabled : true
			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			itemId:'fieldcontainerPeriodAndSectionAndCourseId',
			hidden:false,
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PERIOD'),
				name : 'period',
				itemId : 'period_Id',
				store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				disabled : true
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('SECTION'),
				name : 'programCoursesection',
				itemId : 'programCoursesection_ID',
				store : 'attendance.SectionAndFacultyByPeriodID',
				displayField : 'sectionCode',
				valueField : 'sectionId',
				typeAhead : true,
				forceSelection : true,
				disabled : true
			},{
				xtype: 'customcombobox',
				itemId: 'courseId',
				name: 'COURSE_ID',
				disabled:true,
				fieldLabel:  getCommonTranslation('COURSE_CODE_NAME'),
				store:'coursetransaction.coursereading.CourseByPeriod',
				displayField: 'valueCode',
				valueField: 'id',
				typeAhead: false,
				forceSelection: true,
				triggerAction: 'all',
				queryParam:'name',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}
			}]
		},
		//this is for section group 
		{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			itemId:'fieldContainerSectionGroupId',
			hidden:true,
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'SECTION_GROUP_ACADEMIC_TERM',
				itemId : 'sectionGroupAcademicTerm',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : false,
//				hidden:true,
				store:'Academia.store.common.AcademicTermStore',
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('SECTION_GROUP'),
				name : 'SECTION_GROUP_NAME',
				itemId : 'sectionGroupId',
				store : 'coursetransaction.sectionmanagement.SectionGroup',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				width: 226,
				allowBlank:true,
				hidden:true
				
			}]
			}
		,
		{
			xtype : 'fieldcontainer',
			width: 'auto',
			itemId:'fieldContainerSectionGroupPBSId',
			hidden:true,
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//				translationKey: 'PROGRAM',
				name : 'sectionGroupProgramName',
				itemId : 'sectionGroupProgramId',
				store:'programCourseDashboard.ProgramsBySectionGroupIdStore',
				//store : 'common.AssignedProgramStore',
				displayField:'valueCode',
				valueField:'id',
				width:226,
				//typeAhead:true,
				forceSelection:true,
				disabled:true,
				hidden:true,
				queryParam:'name',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'sectionGroupBatchName',
				itemId:'sectionGroupBatchId',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				disabled:true,
				store: 'enquiry.AcademicBatchForSectionGroupStore',
				valueField: 'id',
				displayField: 'value',
				//typeAhead:true,
				forceSelection:true,
				width: 226,
				hidden:true
			},{
				xtype: 'customcombobox',
				name: 'sectionGroupPeriodName',
				itemId:'sectionGroupPeriodId',
				fieldLabel: getExaminationTranslation('PERIOD'),
				store:null,
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				disabled:true,
				width: 226,
				hidden:true
			}]
		}
		,{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			itemId:'fieldContainerSectionGroupCVId',
			hidden:true,
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel :  getCommonTranslation('COURSE_CODE_NAME'),
				name : 'sectionGroupCourse',
				itemId : 'sectionGroupcourse_Id',
				store:'programCourseDashboard.CoursesBySectionGroupIdStore',
				//store : 'course.AssignedPeriodCoursesFacultyStore',
				displayField:'valueCode',
				valueField:'id',
				typeAhead : false,
				forceSelection : true,
				hidden : false,
				disabled : true,
				triggerAction: 'all',
				queryParam:'name',
				hidden:true,
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
				name:'SECTION_GROUP_COURSE_VARIENT_NAME',
				itemId: 'sectionGroupCourseVariantId',
			    store:'coursetransaction.sectionmanagement.CoruseVariantSectionStore',
				displayField: 'code',
				valueField: 'id',
				typeAhead:true,
				forceSelection:true,
				allowBlank:true,
				disabled:true,
				hidden:true
			}]
		}
		
		
		
		
		
		
		,{
			xtype : 'fieldcontainer',
			itemId:'facultyCodeNameId',
			width: 'auto',
			hidden : true,
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name:'facultyId',
				itemId:'facultyId_itemId',
				store: 'program.programDetails.programBatches.courseParameter.FacultyCombo',
				fieldLabel :getCommonTranslation('FACULTY_CODE_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'nameOrCode',
				minChars:3,
				typeAhead:false,
				enableKeyEvents  : 'true',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: 'all',
				forceSelection:true,
				width : 420,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
		},{
			xtype : 'fieldcontainer',
			itemId : 'studentPeriodContainerItemId',
			hidden : true,
			layout : 'hbox',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				name : 'studentBatch',
				itemId : 'student_batch_Id',
				store : 'enquiry.AcademicBatchStore',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				disabled : true
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PERIOD'),
				name : 'studentPeriod',
				itemId : 'student_period_Id',
				store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				disabled : true
			},{
				xtype: 'customcombobox',
				name:'studentId',
				itemId:'studentId',
				store: 'programCourseDashboard.ActiveStudentStore',
				fieldLabel : getProgramandcourseTranslation('ADMISSION_CODE_STUDENT_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'code',
				minChars:3,
				typeAhead:false,
				enableKeyEvents  : 'true',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: 'all',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value} / {code}' +
						'</div>';
					}
				}
			}]
		},{
			xtype : 'fieldcontainer',
			itemId:'roomComboId',
			width: 'auto',
			hidden : true,
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 420,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'room',
				itemId: 'roomId',
				fieldLabel:getCourseTxCommonTranslation('Room'),
				store : 'resourceutilization.ResourcesStore',
				displayField : 'value',
				valueField : 'id',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				triggerAction: 'all',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items : [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'scheduleSearchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'scheduleResetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype : 'button',
				text : getProgramandcourseTranslation('VIEW_CALENDAR'),
				itemId : 'viewCalanderId',
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				disabled : true
			}]
		}]
	}]
});
