/**
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.criteriabuilder.SavedAdvanceSearchCriteria', {
	extend : 'Ext.form.Panel',
	alias : 'widget.savedadvancesearchcriteria',
	autoScroll: false,
    width: '100%',
    cls: 'panelNoSpace',
    autoWidth: true,
    layout: {
        type: 'hbox'
    },
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            items: [{
                xtype: 'treepanel',
                itemId:'saveSearchCriteriaTreePanel',
                title: getCommonTranslation('SELECT_REPORT'),
                store: store,
                rootVisible: false,
                cls: 'no-tree-icon',
                width: 250,
                minHeight: 600,
                frame: true,
                border: true,
                collapsible: true,
                animCollapse: false,
                collapseDirection: 'left',
                titleCollapse: true,
                floatable: false
            }, {
                xtype: 'savedadvancesearchtab',
                itemId: 'advanceSearchCriteriaTab',
                style:{marginTop:'3px !important'}, 
            }]
        });
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.criteriabuilder.SavedSearchCriteriaConfig');
    }
});