Ext.define('Academia.view.dashboard.OveriddenUserAccessibleGrid',{
    extend: 'Ext.grid.Panel',
    alias: 'widget.overiddenuseraccessiblegrid',
    border: true,
    viewConfig: {
        stripeRows: true
    },
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.callParent(arguments);
    },
    
    tbar : [/*{
		xtype: 'button',
		itemId: 'grantAccess',
		tooltip : getCommonTranslation('GRANT_ACCESS'),
		text: getCommonTranslation('GRANT_ACCESS'),
		cls: 'dashbordOtherTbarBtn'
	},*/{
		xtype: 'button',
		itemId: 'deleteBtn',
		tooltip : getCommonTranslation('GRANT_ACCESS'),
		//cls: 'CustomToolbarBtnReject',
		text: getCommonTranslation('GRANT_ACCESS'),// DELETE,
		cls: 'dashbordOtherTbarBtn'
	}],
    selType: 'checkboxmodel',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
    columns: [{
        header: getCommonTranslation('PORTAL'),
        dataIndex: 'portalName',
        sortable: true,
        flex: 1
    }, /*{
        header: getCommonTranslation('ROLE_NAME'),
        dataIndex: 'roleName',
        sortable: true,
        flex: 1
    },*/ {
        header: getCommonTranslation('DASHLET_CODE'),
        dataIndex: 'dashletCode',
        sortable: true,
        flex: 1,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			} else {
				return value;
			}                 
		}
    },/*{
        header: getCommonTranslation('DASHLET_CATEGORY'),
        dataIndex: 'dashletCategory',
        sortable: true,
        flex: 1
    },*/ {
        header: getCommonTranslation('ACCESS_GRANTED'),
        dataIndex: 'whetherAccessGranted',
        sortable: true,
        flex: 1,
		renderer : function(value){
			return value ?  getCommonTranslation('GRANTED'): getCommonTranslation('NOT_GRANTED');
		}
    }],    

    buildStore: function() {
        return Ext.create('Academia.store.dashboard.UserOveriddenDashletStore');
    }
});
    
        
