/**
 * @author Akshay Sharma
 * 
 */
var periodId = null;
var sectionId = null;
var programName = null;
var studentAttendancetypeCD = null;
var attendanceTypeCD = [];
var programWise = false;
var sessionWise = false;
var permissionList=null;
Ext.define('Academia.view.dashboard.dashlets.FacultyCalendarDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.facultycalendardashlet',
	graphView:false,
	layout:'card',
	activeItem: 0, 
	cls:'FacultyCalendarDashletCLS dashlet',
	autoScroll:true,
	loadDashlet :function(){
		var this$=this;
		var view = this.layout.getActiveItem();
		var userInfo=this.getCurrentlyLoggedInDashletUser();
		var UserInfoModel =  Academia.model.authentication.UserInfoModel;
		var portalId = UserInfoModel.get('portalId');
		userId = this$.getCurrentlyLoggedInDashletUser().id;
		academyLocationId = this$.getUserCurrentAcademyLocation();
		var permissionsMap = new Ext.util.HashMap();
		if(portalId=="2"){
		permissionsMap = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_CALENDAR_DASHLET_PRIVILEGES');
		}
		else if(portalId=="7"){
			permissionsMap = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_CALENDAR_DASHLET_PRIVILEGES');
		}
		else{
			permissionsMap = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_CALENDAR_DASHLET_PRIVILEGES');
		}
		
		var associatedAcadLocationIds = new Array();
	    associatedAcadLocationIds.push(academyLocationId);
		permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		
		if(view.itemId == 'dashletViewCalendarId'){
			if(userInfo.portalId == 3 || userInfo.portalId == 7){
				var params = new Object();
				var dashboardController = Academia.app.getController('Academia.controller.dashboard.DashboardController');
				dashboardController.loadSectionIdForStudent(view);
			}else if(userInfo.portalId == 2){
				var params = new Object();
				view.eventStore.getProxy().actionMethods.read = 'GET';
				params.facultyId = userInfo.id;
				params.academyLocationIds = userInfo.academyLocationIds;
				view.eventStore.removeAll();
				view.eventStore.getProxy().url =  SERVERURL.PATH_GET_MASTER_TIMETABLE;
				view.eventStore.getProxy().extraParams = params;
				view.eventStore.load();
			}
		} else if(view.itemId == 'dashletDetailedViewCalendarId'){
			if(userInfo.portalId == 3 || userInfo.portalId == 7){
				var studentId =  this.getCurrentlyLoggedInUserInfoForPortalDashlet().student.id;
				var params = new Object();
				view.eventStore.getProxy().actionMethods.read = 'GET';
				//params.studentId = userInfo.id;
				params.studentId = studentId;
				view.eventStore.removeAll();
				view.eventStore.getProxy().url = SERVERURL.STUDENT_SCHEDULE_DETAILS;
				view.eventStore.getProxy().extraParams = params;
				view.eventStore.load();
			} else if(userInfo.portalId == 2){
				var params = new Object();
				var endTime = Ext.Date.add (view.startDate,Ext.Date.DAY,6)
				view.eventStore.getProxy().actionMethods.read = 'GET';
				params.facultyId = userInfo.id;
				/*params.start = Ext.Date.format(view.startDate, 'm.d.Y');
				params.end = Ext.Date.format(endTime, 'm.d.Y');*/
				view.eventStore.removeAll();
				view.eventStore.getProxy().url = SERVERURL.FACULTY_SCHEDULE_DETAILS_WITH_DATE;
				view.eventStore.getProxy().extraParams = params;
				view.eventStore.load();
			}
		} else if(view.itemId == 'dashletEventViewCalendarId'){
			if(userInfo.portalId == 3 || userInfo.portalId == 7){
				var studentId =  this.getCurrentlyLoggedInUserInfoForPortalDashlet().student.id;
				var params = new Object();
				view.eventStore.removeAll();
				view.eventStore.getProxy().actionMethods.read = 'GET';
				//params.studentId = userInfo.id;
				params.studentId = studentId;
				view.eventStore.getProxy().url =  SERVERURL.STUDENT_EVENT_DETAILS;
				view.eventStore.getProxy().extraParams = params;
				view.eventStore.load();
			} else if(userInfo.portalId == 2){
				var params = new Object();
				view.eventStore.removeAll();
				view.eventStore.getProxy().actionMethods.read = 'GET';
				params.facultyId = userInfo.id;
				view.eventStore.getProxy().url = SERVERURL.FACULTY_EVENT_DETAILS;
				view.eventStore.getProxy().extraParams = params;
				view.eventStore.load();
			}
		}
		
	},
	defaults: {
		cls:'panelNoSpace'
	},
	items:[{
		xtype: 'calendarpanel',
		itemId: 'dashletDetailedViewCalendarId',
		layout: 'fit',
		toolBarDateTitleWidth: '50%',
		//autoScroll:true,
		border: true,
		width: '100%',
		height: '100%',
		minHeight: 400,
		padding:0,
		margin:0,
		flex:1,
		region: 'center',
		activeItem: 3,
		eventStore:new Ext.create('Ext.calendar.data.MemoryEventStore', {}),
		calendarStore:new Ext.create('Ext.calendar.data.MemoryCalendarStore', {}),
		showDayView:false,
		showWeekView:true,
		showMonthView:false,
		showNavBar: true,
		/*monthViewCfg: {
			showHeader: true,
			showWeekLinks: true,
			showWeekNumbers: true
		},*/
		listeners:{
			activate:function(portlet){
				var facultycalendardashlet=portlet.up('facultycalendardashlet');
				var grid = facultycalendardashlet.getLayout().getActiveItem();
				facultycalendardashlet.activeTab = 1;
				if((Ext.Array.contains(permissionList, 'DETAILED_TIMETABLE'))){
				facultycalendardashlet.addDetailedTimeTable(facultycalendardashlet,portlet);
				}
				if((Ext.Array.contains(permissionList, 'MASTER_TIMETABLE'))){
					facultycalendardashlet.addMasterTimeTable(facultycalendardashlet,portlet);
					}
				if((Ext.Array.contains(permissionList, 'EVENTS'))){
					facultycalendardashlet.addEventTimeTable(facultycalendardashlet,portlet);
					}
				
				
				
				portlet.doLayout(); 
			},
			deactivate:function(portlet){
				var facultycalendardashlet=portlet.up('facultycalendardashlet');
				if((Ext.Array.contains(permissionList, 'DETAILED_TIMETABLE'))){
					facultycalendardashlet.removeDetailedTimeTable(facultycalendardashlet);
					}
					if((Ext.Array.contains(permissionList, 'MASTER_TIMETABLE'))){
						facultycalendardashlet.removeMasterTimeTable(facultycalendardashlet);
						}
					if((Ext.Array.contains(permissionList, 'EVENTS'))){
						facultycalendardashlet.removeEventTimeTable(facultycalendardashlet);
						}
				
				
				
			},
		}
	},{
		xtype: 'calendarpanel',
		itemId : 'dashletViewCalendarId',
		layout: 'fit',
		toolBarDateTitleWidth: '50%',
		border: true,
		width: '100%',
		height: '100%',
		minHeight: 450,
		padding:0,
		margin:0,
		flex:1,
		region: 'center',
		activeItem: 3,
		eventStore:new Ext.create('Ext.calendar.data.MemoryEventStore', {}),
		calendarStore:new Ext.create('Ext.calendar.data.MemoryCalendarStore', {}),
		showDayView:false,
		showWeekView:false,
		showMonthView:true,
		showNavBar: true,
		weekViewCfg: {
			viewStartHour: 0,
			viewEndHour: 24
		},
		listeners:{
			activate:function(portlet){
				var facultycalendardashlet=portlet.up('facultycalendardashlet');
				var grid = facultycalendardashlet.getLayout().getActiveItem();
				facultycalendardashlet.activeTab = 2;
				if((Ext.Array.contains(permissionList, 'DETAILED_TIMETABLE'))){
					facultycalendardashlet.addDetailedTimeTable(facultycalendardashlet,portlet);
					}
					if((Ext.Array.contains(permissionList, 'MASTER_TIMETABLE'))){
						facultycalendardashlet.addMasterTimeTable(facultycalendardashlet,portlet);
						}
					if((Ext.Array.contains(permissionList, 'EVENTS'))){
						facultycalendardashlet.addEventTimeTable(facultycalendardashlet,portlet);
						}
				portlet.doLayout();
			},
			deactivate:function(portlet){
				var facultycalendardashlet=portlet.up('facultycalendardashlet');
				if((Ext.Array.contains(permissionList, 'DETAILED_TIMETABLE'))){
					facultycalendardashlet.removeDetailedTimeTable(facultycalendardashlet);
					}
					if((Ext.Array.contains(permissionList, 'MASTER_TIMETABLE'))){
						facultycalendardashlet.removeMasterTimeTable(facultycalendardashlet);
						}
					if((Ext.Array.contains(permissionList, 'EVENTS'))){
						facultycalendardashlet.removeEventTimeTable(facultycalendardashlet);
						}
				
			},
		}
	},{ 
		xtype: 'calendarpanel',
		itemId: 'dashletEventViewCalendarId',
		layout: 'fit',
		toolBarDateTitleWidth: '50%',
		border: true,
		width: '100%',
		height: '100%',
		minHeight: 450,
		padding:0,
		margin:0,
		flex:1,
		region: 'center',
		activeItem: 3,
		eventStore:new Ext.create('Ext.calendar.data.MemoryEventStore', {}),
		calendarStore:new Ext.create('Ext.calendar.data.MemoryCalendarStore', {}),
		showDayView:false,
		showWeekView:false,
		showMonthView:true,
		showNavBar: true,
		/*monthViewCfg: {
			showHeader: true,
			showWeekLinks: true,
			showWeekNumbers: true
		},*/
		listeners:{
			activate:function(portlet){
				var facultycalendardashlet=portlet.up('facultycalendardashlet');
				var grid = facultycalendardashlet.getLayout().getActiveItem();
				facultycalendardashlet.activeTab = 3;
				if((Ext.Array.contains(permissionList, 'DETAILED_TIMETABLE'))){
					facultycalendardashlet.addDetailedTimeTable(facultycalendardashlet,portlet);
					}
					if((Ext.Array.contains(permissionList, 'MASTER_TIMETABLE'))){
						facultycalendardashlet.addMasterTimeTable(facultycalendardashlet,portlet);
						}
					if((Ext.Array.contains(permissionList, 'EVENTS'))){
						facultycalendardashlet.addEventTimeTable(facultycalendardashlet,portlet);
						}
				portlet.doLayout();
			},
			deactivate:function(portlet){
				var facultycalendardashlet=portlet.up('facultycalendardashlet');
				if((Ext.Array.contains(permissionList, 'DETAILED_TIMETABLE'))){
					facultycalendardashlet.removeDetailedTimeTable(facultycalendardashlet);
					}
					if((Ext.Array.contains(permissionList, 'MASTER_TIMETABLE'))){
						facultycalendardashlet.removeMasterTimeTable(facultycalendardashlet);
						}
					if((Ext.Array.contains(permissionList, 'EVENTS'))){
						facultycalendardashlet.removeEventTimeTable(facultycalendardashlet);
						}
				
			},
		}
	}]
});
