Ext.define('Academia.view.dashboard.dashlets.StudentDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.studentdashlet',

	    graphView:true,
	    layout:'card',
	    activeItem: 0, 
	    autoScroll:false,
	    cls:'ReadingMaterialDashletCLS dashlet',
		loadDashlet :function(){
			var this$=this;
			var grid= this.layout.getActiveItem();
			var jsonFormatFormData = this$.createJsonFormat();
			var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        	resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.STUDY_MATERIAL_DISTRIBUTION_REPORT_VIEW_CODE);
        	grid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
		},
		createJsonFormat:function(){			
    		var values = new Object();
    		values.configCode = CONSTANTS.CB.STUDY_MATERIAL_DISTRIBUTION_REPORT_CONFIG_CODE;
    		var searchcriteria = new Array();
    		var baseController = Academia.app.getController('Academia.controller.base.BaseController');
    		var studentId = baseController.getCurrentlyLoggedInUserInfoForPortal().student.id;
    		var academyLocationId = baseController.getCurrentAcademyLocation();
    		if(!isNullOrEmpty(studentId)){
    			searchcriteria.push({paramCode:"STUDENT_ID", paramValues:[studentId]});
    		}
    		if(!isNullOrEmpty(academyLocationId)){
    			searchcriteria.push({paramCode:"ACADEMY_LOCATION_ID", paramValues:[academyLocationId]});
    		}
    		
    		
    		values.searchCriterias=searchcriteria;
    		return values;
    	},
		defaults: {
			cls:'panelNoSpace',
			xtype:'griddashlet'
	    },
	    
		items:[{
		    xtype:'searchresultgrid',
		    title: false,
		    itemId:'studentDashletGridId',
			columns : [],
			listeners:{
				activate:function(portlet){
					var studentdashlet=portlet.up('studentdashlet');
//					studentdashlet.addExportToPdf(studentdashlet);
					studentdashlet.activeTab =1;
//					studentdashlet.addGraphViewButton(studentdashlet);
					studentdashlet.addExportToPdfSearchResultGrid(studentdashlet,portlet);
					studentdashlet.addExportToExcelSearchResultGrid(studentdashlet,portlet);
					portlet.doLayout();
				},
				/*deactivate:function(portlet){
						var studentdashlet=portlet.up('studentdashlet');
						studentdashlet.removeGraphViewButton(studentdashlet);
						studentdashlet.removeExportToPdf();
						studentdashlet.removeExportToExcel();
				}*/
			}
		}/*,{
			xtype:'columnchartdashlet',
			xAxesCategoryField :['date'],
			yAxesNumericField : ['count'],
			xAxesCategoryTitle :'Date',
			yAxesNumericTitle :'Count',
			model:'Academia.model.enquiry.EnquiryFollowupDashletGraphModel',
			url : SERVERURL.ENQUIRY_FOLLOWUP_DASHLET_GRAPH,
			listeners:{
				activate:function(portlet){
					var enquiryfollowupdashlet=portlet.up('enquiryfollowupdashlet');
					enquiryfollowupdashlet.activeTab = 0;
					enquiryfollowupdashlet.addGridViewButton(enquiryfollowupdashlet);
					enquiryfollowupdashlet.addExportToPng(enquiryfollowupdashlet,portlet);
				},
				deactivate:function(portlet){
					var enquiryfollowupdashlet=portlet.up('enquiryfollowupdashlet');
					enquiryfollowupdashlet.removeGridViewButton(enquiryfollowupdashlet);
					enquiryfollowupdashlet.removeExportToPng();
				}
			}
		}*/]
	});
