/**
 * @author saket.puranik
 * 
 * This component is used for to show window with department details. 
 */
Ext.define('Academia.view.department.DepartmentFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.departmentformwindow',
    modal: true,
    resizable: false,
    title: getCommonTranslation('DEPARTMENT_DETAILS'), //Department Details	
    defaults: {
        labelStyle: 'padding-left:50px;'
    },
    margin: 0,
    items: [{
        xtype: 'idgeneratorform',
        formCode: 'departmentForm',
        itemId: 'departmentForm',
        method: 'POST',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'department_hidden_field',
            name: 'id'
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                fieldLabel: getCommonTranslation('ACADEMY_LOCATION_ID'), //Academy Location Id
                xtype: 'customcombobox',
                itemId: 'academyLocationId',
                store: 'department.AcademyLocationDepartmentStore',
                valueField: 'id',
                displayField: 'value',
                allowBlank: false,
                emptyText: getCommonTranslation('SELECT_ACADEMY_LOCATION'), //Select Academy Location
                editable: false,
                queryMode: 'remote',
                triggerAction: 'all',
                forceSelection: true
            }, {
                fieldLabel: getCommonTranslation('SHORTCODE'), //Short Code
                xtype: 'textfield',
                itemId: 'shortCode',
                name: 'shortCode',
                maxLength: 55,
                emptyText: getCommonTranslation('ID_AUTOGENERATE'),
               // readOnly : true
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                fieldLabel: getCommonTranslation('DEPARTMENT_ID'), //Deparetment ID
                xtype: 'textfield',
                itemId: 'serialId',
                name: 'serialId',
                allowBlank: false
            }, {
                fieldLabel: getCommonTranslation('DEPARTMENT_NAME'), //Department Name
                xtype: 'textfield',
                itemId: 'name',
                name: 'name',
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'customcombobox',
                name: 'cmbDeptType',
                itemId: 'cmbDeptType',
                fieldLabel: getCommonTranslation('DEPARTMENT_TYPE'), //Department Type
                store: 'department.DepartmentTypeStore',
                valueField: 'value',
                displayField: 'value',
                editable: false,
                emptyText: getCommonTranslation('SELECT_TEXT'), //---Select---
                queryMode: 'local',
                triggerAction: 'all',
                forceSelection: true,
                allowBlank: false
            }, {
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('HEAD_OF_DEPT'), //Head Of Department
                name: 'id',
                store: 'department.HeadOfDepartmentStore',
                displayField: 'valueCode',
                editable: false,
                valueField: 'id',
                itemId: 'cmbHod',
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'datefield',
                name: 'hodFromDate',
                itemId: 'hodFromDate',
                vtype: 'daterange',
                editable: false,
                endDateField: 'hodToDate',
                //--submitFormat: CONSTANTS.DATE_FORMAT,
                fieldLabel: getCommonTranslation('HOD_FROM_DATE'),//HOD From Date
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				} 
            }, {
                xtype: 'datefield',
                fieldLabel: getCommonTranslation('HOD_TILL_DATE'), //HOD Date Till
                name: 'hodToDate',
                itemId: 'hodToDate',
                vtype: 'daterange',
                editable: false,
                startDateField: 'hodFromDate',
              //--submitFormat: CONSTANTS.DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'statusCombo',
                name: 'status',
                itemId: 'cmbStatus',
                labelAlign: 'top',
                editable: false,
                emptyText: getCommonTranslation('SELECT_TEXT'), //---Select---
                allowBlank: false
            }, {
                xtype: 'checkboxfield',
                boxLabel: getCommonTranslation('ALLOW_SUB_DEPT'), //Allow Sub-departments
                name: 'hasSubDepartment',
                itemId: 'chkSubDept',
                region: 'south',
                style: {
                    marginTop: '25px',
                    marginLeft: '5px'
                },
                labelAlign: 'top',
                inputValue: 'true',
                uncheckedValue: 'false'
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            items: [{
                xtype: 'button',
                itemId: 'btnSaveDepartmentForm',
                text: getCommonTranslation('SAVE'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelDepartmentForm',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});