/**
 * @author Deepak Sharma
 */
Ext.define('Academia.view.documentmanagement.DocumentTemplateApplyToALViewWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.documenttemplateapplytoalviewwindow',
	title: getExaminationTranslation('APPLY_TO'),
	modal: true,
	autoScroll:true,
	maxHeight:500,
	width: '42%',
	height:'38%',
	items: [{
		xtype: 'form',
		method: 'POST',
		itemId:'academyLocationDocumentTemplateForm',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		autoScroll:true,
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			style:{
				marginLeft:'15px'
			},
			defaults :{
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype:'textfield',
				name:'configLevel',
				itemId:'configLevel',
				readOnly: true,
				fieldLabel: getDocumentTranslation('DOCUMENT_CATEGORY')
			},{
				xtype:'textfield',
				name:'documentTypeId',
				itemId:'documentTypeId',
				readOnly: true,
				fieldLabel:getDocumentTranslation('DOCUMENT_NAME')
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			style:{
				marginLeft:'15px'
			},
			defaults :{
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype:'textfield',
				name:'templateId',
				itemId:'templateId',
				readOnly: true,
				fieldLabel:getDocumentTranslation('TEMPLATE_NAME')
			},{
				xtype:'textfield',
				name:'academyLocationId',
				itemId:'academyLocationId',
				readOnly: true,
				fieldLabel:getProgramandcourseTranslation("ACADEMY_LOCATION")
			},{
				xtype:'textfield',
				name:'communityId',
				itemId:'communityId',
				readOnly: true,
				hidden:true,
				fieldLabel:getDocumentTranslation('COMMUNITY')
			}]
		},{
			xtype: 'fieldcontainer',
			itemId:'courseCodeFldCont',
			hidden:true,
			layout: {
				type: 'hbox'
			},
			style:{
				marginLeft:'15px'
			},
			defaults :{
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype:'textfield',
				name:'courseCodeName',
				itemId:'courseCodeName',
				readOnly: true,
				fieldLabel:getCommonTranslation("COURSE_CODE_NAME")
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			style:{
				marginLeft:'15px'
			},
			items: [{
	            xtype: 'button',
	            text: getServiceRequestTranslation('CANCEL'),
	            ui: 'CustomBtnCancel',
	            itemId: 'cancelButtonId',
	            scale: CONSTANTS.BUTTONSIZE,
	            handler :function(button) {
	            	button.up('window').close();
	            }
	        }]
		}]
	}]
});