Ext.define('Academia.view.documentmanagement.StudentGroupDocumentRequestGrid',{
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.studentgroupdocumentrequestgrid',
    store: 'documentmanagement.DocumentStudentRequestGridStore',
    title: getCommonTranslation('STUDENTS'),
    border: true,
    autoScroll: false,
    refreshStoreData:true,
    selType:'checkboxmodel',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'documentmanagement.DocumentStudentRequestGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [{
		 xtype: 'button',
		 itemId: 'sendMsgBtn',
		 text:getCommonTranslation('SEND_MESSAGE'),
		 tooltip :getCommonTranslation('SEND_MESSAGE')
    },'->',{
		xtype:'displayfield',
		name : 'groupName',
		itemId : 'groupNameDisplayId',
		hidden:true
	}],
    columns: [{
    	header: getAdmissionTranslation('ADMISSION_ID'),
    	dataIndex: 'admissionCode',
    	flex: 1
    },{
    	header: getAdmissionTranslation('STUDENT_ID'),
    	dataIndex: 'studentCode',
    	flex: 1
    	/*renderer:function(val,rec){
			return rec.record.data.studentCode;
		}*/
    }, {
    	header: getCommonTranslation('STUDENT_NAME'),
    	dataIndex: 'studentName',
    	flex: 1,
    	renderer:function(val,rec){
			return rec.record.data.studentName;
		}
    },{
    	header: getAdmissionTranslation('PROGRAM'),
    	dataIndex: 'programName',
    	flex: 1,
    }, {
    	header: getCommonTranslation('INTAKE'),
    	dataIndex: 'batchName',
    	flex: 1,
    	
    }, {
    	header: getCommonTranslation('SECTION'),
    	dataIndex: 'section',
    	flex: 1,
    }, {
    	header: getCommonTranslation('REQUESTED_ON'),
    	dataIndex: 'requestedOn',
    	flex: 1,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    }, {
    	header: getCommonTranslation('HW_SUBMISSION_DATE'),
    	dataIndex: 'completedOn',
    	flex: 1,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    },{
    	header: getCommonTranslation('STATUS'),
    	dataIndex: 'documentStatus',
    	flex: 1,
    },{
    	header: getCommonTranslation('DOCUMENT_VIEW'),
    	dataIndex: 'documentView',
    	flex: 1,
    	renderer: function(value, metadata, record) {
    		var msg = '<a href="#">' + "View" + '</a>';
    		if (!isNullOrEmpty(value) && !isNullOrEmpty(value)) {
    			msg = '<a href="#">' + "View" + '</a>';
    		}
    		return msg;
    	}
    }
    ],
});