/**
 * @author Pritam.Patil
 * This component is used for template List Grid
 */
Ext.define('Academia.view.documentmanagement.TemplateListGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.templatelistgrid',
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: true
    },
    headerFix:{
        headerFix: true,
        portalIdsWithStructure: {
            'templatelistview':1
        }
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'

    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELET'),
        glyph: ICONGLYPH.DELETEGLYPH

    }, {
        xtype: 'button',
        text: getDocumentTranslation('MARK_DEFAULT_TEMPLATE'),
        itemId: 'markDefaultTemplateButton',
        scale: CONSTANTS.BUTTONSIZE
    }],
    columns: [{
        header: getDocumentTranslation('DOCUMENT_CATEGORY'),
        dataIndex: 'configLevel',
        //align: 'center',
        sortable: true,
        flex: .2,
        renderer : function(value){
        	return getDocumentTranslation(value);
        }
    }, {
        header: getDocumentTranslation('DOCUMENT_NAME'),
        dataIndex: 'documentTypeName',
        //align: 'center',
        sortable: true,
        flex: .2
    }, {
        header: getDocumentTranslation('TEMPLATE_TYPE'),
        dataIndex: 'templateType',
        //align: 'center',
        sortable: true,
        flex: .2,
        renderer : function(value){
        	return getDocumentTranslation(value);
        }
    }, {
        header: getDocumentTranslation('TEMPLATE_NAME'),
        dataIndex: 'templateName',
        //align: 'center',
        sortable: true,
        flex: .2
    }, {
	    header: getDocumentTranslation('DEFAULT_TEMPLATE'),
	    dataIndex: 'whetherDefault',
	    sortable: true,
	    flex: .2,
	    renderer: function(value){
	    	var msg;
	    	if(!isNullOrEmpty(value)){
	    		if(value){
	    			msg = getCommonTranslation('TRUE');
	    		}else{
	    			msg = getCommonTranslation('FALSE');
	    		}
	    	}else{
	    		msg = value;
	    	}
	    	return msg;
	    }
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.documentmanagement.Templates');
    }
});