/**
 * @author Pankaj Sisodiya
 * 
 */
Ext.define('Academia.view.emailAccountStatement.EmailAccountStatementFilter',{
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias:'widget.emailAccountStatementFilter',
	autoScroll:false,
	frame:false,
	standardSubmit:false,
	cls:'panelNoSpace',
	plugins:"formlabelrequired",
	items:[{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			defaults:{
				labelAlign:'top'
			},
			items:[{
				xtype: 'multiselectcombofield',
				name: 'academyLocationItemId',
				itemId: 'academyLocationItemId',
				fieldLabel:getCommonTranslation('ACADEMY_LOCATION'),
				width: 740,
				store:'emailAccountStatement.EmailAccountAcademiaLocationStore',
				allowBlank : false,
				valueField : 'id',
				forceSelection : true,
				displayField : 'value',
				hideTrigger:false,
				triggerAction: 'all'	
			}]
		},{

			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype: 'multiselectcombofield',
				name: 'programGroupId',
				itemId: 'programGroupId',
				fieldLabel:getFeeAndPaymentCommonTranslation('PROGRAM_GROUP'),
				store:'program.ProgramGroupStoreForLocalSerach',
				valueField : 'id',
				forceSelection : true,
				displayField : 'value',
				hideTrigger:false,
				_isStoreLoadCalled:true,
				triggerAction: 'all'
			},{
				xtype: 'multiselectcombofield',
				name:'programNameOrCode',
				store: 'emailAccountStatement.EmailAccountProgramBatchSeatStore',
				itemId:'programNameOrCode',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				valueField: 'programId',
				displayField: 'programValue',
				hideTrigger:false,
				_isStoreLoadCalled:true,
				forceSelection : true,
				cls:'resetPasswordMultiselect',
				triggerAction: 'all',
				disabled:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{programCode} / {programName}' +
						'</div>';
					}
				}

			}, {  
				xtype: 'multiselectcombofield', 
				fieldLabel: getCommonTranslation('BATCH'),
				name: 'batchId',
				itemId: 'batchId',
				store: 'emailAccountStatement.EmailAccountBatchStore',
				displayField: 'batchName',
				valueField: 'batchId',
				_isStoreLoadCalled:true,
				typeAhead: false,
				forceSelection: true,  
				cls:'resetPasswordMultiselect',
				hideTrigger: false,
				triggerAction: 'all',
				disabled:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{batchName}' +
						'</div>';
					}
				}
			}]
		},{

			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype: 'multiselectcombofield',
				name: 'periodId',
				itemId: 'periodId',
				_isStoreLoadCalled:true,
				fieldLabel:getCommonTranslation('PERIOD'),
				store:'emailAccountStatement.EmailAccountPeriodStore',
				queryParam: "qry",
				cls:'resetPasswordMultiselect',
				valueField : 'periodId',
				forceSelection : true,
				displayField : 'periodName',
				hideTrigger:false,
				typeAhead:true,
				triggerAction: 'all',
				disabled:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{periodName}' +
						'</div>';
					}
				}
			},{
				xtype: 'multiselectcombofield',
				name: 'seatTypeId',
				itemId: 'seatTypeId',
				cls:'resetPasswordMultiselect',
				_isStoreLoadCalled:true,
				fieldLabel:getCommonTranslation('SEAT_TYPE'),
				store:'emailAccountStatement.EmailAccountSeatTypeStore',
				queryParam: "qry",
				valueField : 'seatTypeId',
				forceSelection : true,
				displayField : 'seatTypeName',
				hideTrigger:false,
				typeAhead:true,
				triggerAction: 'all',
				disabled:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{seatTypeName}' +
						'</div>';
					}
				}
			},{
				xtype: 'multiselectcombofield',
				name: 'studentId',
				itemId: 'studentId',
				_isStoreLoadCalled:true,
				cls:'resetPasswordMultiselect',
				fieldLabel: getCommonTranslation('STUDENT_CODE_NAME'),
				store: 'emailAccountStatement.EmailAccountStudentStore',
				valueField: 'id',
				displayField: 'valueCode',
				typeAhead:true,
				disabled:true,
				triggerAction: 'all',
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{studentCode} / {studentName}' +
    					'</div>';
    				}
    			}
			}, {  
				xtype: 'customcombobox',
				name: 'status',
				fieldLabel: getCommonTranslation('STATUS'),
				value:true,
				hidden:true,
				disabled:true,
				store: 'common.StatusComboStore',
				itemId: 'status',
				valueField: 'value',
				displayField: 'name',
				listeners:{
					afterrender:function(cmp){
						Ext.defer(function(){
							cmp.setValue(true);
						},250)
						
					}
				}
			}]
		},{

			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype: 'customcombobox',
				name:'address',
				store: Ext.create('Ext.data.Store', {
					fields: ['id', 'name'],
					data : [
						{"id":"DEFAULT", "name":getCommonTranslation('FEE_PAYER_ADRESS_DEFAULT_SELECTED')},
						{"id":"CRNT", "name":getCommonTranslation('STUDENT_CURRENT_ADRESS')},
						{"id":"PRMNT", "name":getCommonTranslation('STUDENT_PERMANENT_ADDRESS')},
						{"id":"OFC", "name":getCommonTranslation('STUDENT_OFFICE_ADDRESS')},
						{"id":"CRSPDNC", "name":getCommonTranslation('STDUENT_CORRESPONDENCE_ADDRESS')}
						]
				}),
				itemId:'address',
				fieldLabel: getCommonTranslation('ADDRESS'),
				displayField: 'name',
				    valueField: 'id',
				value:'DEFAULT',
				listeners:{
					afterrender:function(cmp){
						Ext.defer(function(){
							cmp.setValue('DEFAULT');
						},250)
						
					}
				}

			},{
				xtype: 'customcombobox',
				name:'enrollmentStatus',
				store: Ext.create('Ext.data.Store', {
					fields: ['id', 'name'],
					data : [
						{"id":"COURSE_REGISTERED", "name":getCommonTranslation('COURSE_REGISTERED')},
						{"id":"COURSE_NON_REGISTERED", "name":getCommonTranslation('COURSE_NON_REGISTERED')}
						]
				}),
				itemId:'enrollmentStatus',
				fieldLabel: getCommonTranslation('COURSE_ENROLLMENT_STATUS'),
				valueField: 'id',
				displayField: 'name'
				

			}, {  
				xtype: 'multiselectcombofield', 
				fieldLabel: getCommonTranslation('PAYMENT_PLAN_ENROLLED'),
				name: 'paymentPlanEnrolled',
				cls:'resetPasswordMultiselect',
				itemId: 'paymentPlanEnrolled',
				store: 'emailAccountStatement.EmailAccountPaymentPlanStore',
				displayField: 'value',
				valueField: 'id',
				hideTrigger:false,
				_isStoreLoadCalled:true,
				forceSelection : true,
				disabled:true,
				triggerAction: 'all'
			}]
		},{

			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{  
				xtype: 'customcombobox', 
				  fieldLabel: getCommonTranslation('TYPE_OF_BALANCE'),
				    name: 'typeOfBalance',
				    itemId: 'typeOfBalance',
				value:'ALL',
				   store: Ext.create('Ext.data.Store', {
					fields: ['id', 'name'],
					data : [
						{"id":"DEBIT", "name":getCommonTranslation('DEBIT')},
						{"id":"CREDIT", "name":getCommonTranslation('CREDIT')},
						{"id":"ALL", "name":getCommonTranslation('ALL')}
						]
				}),
				    displayField: 'name',
				    valueField: 'id',
				listeners:{
					afterrender:function(cmp){
						Ext.defer(function(){
							cmp.setValue('ALL');
						},250)
						
					}
				}
			},{
				xtype: 'numberfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('MINIMUM_AMOUNT'),
				name: 'minAmount',
				itemId:'minAmount',
				enforceMaxLength:true,
				decimalPrecision: 2,
				maxLength:13,
				maxValue: 9999999999.99,
				minValue:0,
				hideTrigger: false,
				keyNavEnabled: false,
				mouseWheelEnabled: false

			}, {
				xtype: 'numberfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('MAXIMUM_AMOUNT'),
				name: 'maxAmount',
				itemId:'maxAmount',
				enforceMaxLength:true,
				decimalPrecision: 2,
				maxLength:13,
				maxValue: 9999999999.99,
				minValue:0,
				hideTrigger: false,
				keyNavEnabled: false,
				mouseWheelEnabled: false

			}]
		},{

			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype: 'datefield',
				name: 'statementFrom',
				itemId: 'statementFrom',
				vtype: 'daterange',
				endDateField: 'statementTill',
				editable:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('STATEMENT_FROM'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}

			},{
				xtype: 'datefield',
				name: 'statementTill',
				itemId: 'statementTill',
				vtype: 'daterange',
				editable:false,
				startDateField: 'statementFrom',
				fieldLabel: getCommonTranslation('STATEMENT_TILL'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}

			},
			{
	        	xtype: 'checkboxfield',
	        	labelAlign: 'right',
	        	style:{
	        		//marginLeft:'8px',
	        		marginTop:'25px'
	        	},
	        	itemId:'withZeroOutstandingId',
	        	disabled: false,
	        	boxLabel: getCommonTranslation('WITH_ZERO_OUTSTANDING'),
	        	name: 'withZeroOutstanding',
	        	inputValue : true
	        }
			]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('ADD_CRITERIA'),
				itemId: 'addCriteriaBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtnItemId',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	}]
});