/**
 * @author Pankaj Sisodiya
 * 
 */
Ext.define('Academia.view.emailAccountStatement.SponsorAccountStatementAddCriteriaForm',{
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias:'widget.sponsorAccountStatementAddCriteriaForm',
	autoScroll:false,
	frame:false,
	standardSubmit:false,
	cls:'panelNoSpace',
	plugins:"formlabelrequired",
	items:[{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:280
			},
			items:[{
				xtype: 'customcombobox',
				name: 'accountingYear',
				itemId: 'accountingYear',
				fieldLabel: getCommonTranslation('ACCOUNTING_YEAR'),
				store:'scholarships.ScholarshipAccountingYearStore',
				valueField: 'id',
				displayField: 'currentAccountingYear',
				allowBlank:false,
				typeAhead:true,
				forceSelection:true
			},{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('SCHOLARSHIP_ID_NAME'),
                itemId: 'scholarshipId',
                name: 'scholarshipId',
                enableKeyEvents: true,
                vtype: 'NospaceAsInput',
                store:'emailAccountStatement.SponsorScholarshipIdsStore',
    			width:226,
    			disabled:true,
    			valueField: 'id',
    			displayField: 'valueCode',
    			queryParam:'scholarshipName',
    			minChars:3,
    			typeAhead:false,
    			allowBlank:false,
    			//hideTrigger:true,
    			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			forceSelection:true,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}'  +
    					'</div>';
    				}
    			}
            }, {  
				xtype: 'multiselectcombofield', 
				fieldLabel:getCommonTranslation('SCHOLARSHIP_STATUS'),
				name: 'scholarshipStatus',
				itemId: 'scholarshipStatus',
				store: 'emailAccountStatement.SponserScholarshipStatusStore',
				displayField: 'displayVal',
				valueField: 'code',
				_isStoreLoadCalled:true,
				typeAhead: false,
				forceSelection: true,  
				allowBlank:false,
				disabled:true,
				cls:'resetPasswordMultiselect',
				hideTrigger: false,
				triggerAction: 'all',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{displayVal}' +
						'</div>';
					}
				}
			}]
		},{

			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:280
			},
			items:[{  
				xtype: 'customcombobox', 
				  fieldLabel: getCommonTranslation('STATEMENT_LANGUAGE'),
				    name: 'language',
				allowBlank:false,
				    itemId: 'language',
				value:'ENGLISH',
				   store: Ext.create('Ext.data.Store', {
					fields: ['id', 'name'],
					data : [
						{"id":"ENGLISH", "name":getCommonTranslation('ENGLISH')},
						{"id":"AFRIKAANS", "name":getCommonTranslation('AFRIKAANS')}
						]
				}),
				    displayField: 'name',
				    valueField: 'id',
				listeners:{
					afterrender:function(cmp){
						Ext.defer(function(){
							cmp.setValue('ENGLISH');
						},250)

					}
				}
			},{

	        	xtype: 'checkboxfield',
	        	labelAlign: 'right',
	        	style:{
	        		//marginLeft:'8px',
	        		marginTop:'25px'
	        	},
	        	itemId:'sponserWithZeroOutstandingId',
	        	disabled: false,
	        	boxLabel: getCommonTranslation('WITH_ZERO_OUTSTANDING'),
	        	name: 'sponserWithZeroOutstandingId',
	        	inputValue : true,
	        	checked:false
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('ADD_CRITERIA'),
				itemId: 'sponserAddCriteriaBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'sponserResetBtnItemId',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	}]
});