/**
 * Gajendra Verma
 */

Ext.define('Academia.view.enquiry.closure.EnquiryClosureForm', {   
	extend: 'Ext.window.Window',
	alias : 'widget.enquiryclosureform',
	title: getEnquiryTranslation('CLOSURE_TITLE'),
	autoScroll: true,
	frame: true,
	modal:true,
	items: [{
		xtype: 'form',
		bodyPadding: '5 5 5 5',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items : [{
			xtype: 'radiogroup',
 		    name: 'programExam',
 		    itemId:'programExam_radioBtn',
			items:[
			       {boxLabel : getEnquiryTranslation('CLOSURE'),name:'programExam',inputValue: 0,checked:true},
			       {boxLabel : getEnquiryTranslation('REOPEN'),name:'programExam',inputValue: 1}
			   ]
		},{
			xtype: 'datefield',
			name: 'closureDate',
			itemId:'closureDate',
			fieldLabel:getEnquiryTranslation('CLOSURE_DATE'),
			maxValue:new Date(),
			allowBlank: false,
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
			}

		},{
			xtype: 'customcombobox',
			name: 'closureReason',
			itemId:'closureReasonItemId',
			store: 'enquiry.followup.ClosureReasonStore',
			fieldLabel: getEnquiryTranslation('CLOSURE_REASON'),
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'livesearchcombo',
			queryParam: 'code',
			allowBlank: false,
			name: 'applicationId',
			itemId: 'applicationCmp',
			hidden:true,
			fieldLabel: getCommonTranslation('APPLICATION_ID'),
			displayField: 'value',
			valueField: 'id',
			displayTpl: new Ext.XTemplate('<tpl for="."between=" ">', '{[typeof values === "string" ? values : values["value"]]}' + '</tpl>'),
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.enquiry.followup.ApplicationSearchStore');
					combo.bindStore(store);
				}
			}
		},{
			xtype: 'textarea',
			name: 'closureRemarks',
			itemId: 'closureRemarks',
			fieldLabel: getEnquiryTranslation('CLOSURE_REMARKS'),
			allowBlank: false,
			enforceMaxLength : true,
	      	maxLength:255
		},{
			xtype:'hidden',
			name:'id'
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: {
				type: 'hbox'
			},
			items: [{

				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				itemId: 'closureform_submitbuttonId',
				formBind:true,
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'closureform_cancelbuttonId',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]	
	});