/**
 * @Author Manas Luktuke
 */
var examStore = Ext.create('Academia.store.examCenter.AssignSequence.AssignSeqenceMethodStore')
Ext.define('Academia.view.examCenter.assignSequence.AssignSequencGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.assignsequencgrid',
    store: examStore,
    title: getExaminationTranslation('ASSIGN_EVALUATION_METHOD'),
    frame: false,
    border: true,
    enableColumnHide: true,
    itemId: 'AssignSequencGridId',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: examStore,
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function () {
        var grid = this;
        if (portalId == 1) {
            this.headerFix = {
                headerFix: true,
                portalIdsWithStructure: {
                    'assignsequencstructure': 1
                }
            };
        }
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation("ADD"),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation("EDIT"),
        glyph: ICONGLYPH.EDITGLYPH,
        disabled: false
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation("DELETE"),
        glyph: ICONGLYPH.DELETEGLYPH,
        disabled: false
    }, '->', {
        xtype: 'button',
        itemId: 'exportLessonPlanReportsId',
        tooltip: getCommonTranslation('EXPORT_REPORT'),
        text: getCommonTranslation('EXPORT_REPORT'),
        disabled: true,
        menu: [{
            text: 'Excel',
            itemId: 'excelExportLessionPlansBtn'
        }, {
            text: 'Pdf',
            itemId: 'pdfExportLessionPlansBtn'
        }]
    }],
    columns: [{
        header: getCommonTranslation('ID'),
        dataIndex: 'id',
        flex: 1,
        hidden: true,
        sortable: true
    }, {
        header: getCommonTranslation('ACADEMY_LOCATION_ID'),
        dataIndex: 'academyLocationId',
        flex: 1,
        hidden: true,
        sortable: true,
        renderer: function (value, meta, record) {
            return value;
        }
    }, {
        header: getCommonTranslation('BATCH_ID'),
        dataIndex: 'programBatchId',
        flex: 1,
        hidden: true,
        sortable: true,
        renderer: function (value, meta, record) {
            return value;
        }
    }, {
        header: getCommonTranslation('EVALUATION_PLAN'),
        dataIndex: 'planName',
        flex: 1,
        sortable: true,
        hidden: true,
        renderer: function (value, meta, record) {
            return value;
        }
    }, {
        header: getCommonTranslation('ASSESSMENT_TYPE'),
        dataIndex: 'evaluationType',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation('LOCATION'),
        dataIndex: 'locationName',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation('ACADEMY'),
        dataIndex: 'academyName',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation('PROGRAM_CODE'),
        dataIndex: 'programCode',
        flex: 1,
        sortable: true,
        renderer: function (value, meta, record) {
            return value;
        }
    }, {
        header: getCommonTranslation("BATCH"),
        dataIndex: 'batchName',
        sortable: true,
        flex: 1,
        renderer: function (value, meta, record) {
            return value;
        }
    }, {
        header: getCommonTranslation("NO_OF_SEQUENCE_ASSIGNED"),
        dataIndex: 'countOfSequenceAssigned',
        sortable: true,
        flex: 1,
        renderer: function (value, meta, record) {
            if (!isNullOrEmpty(record.data.countOfSequenceAssigned)) {
                if (record.data.countOfSequenceAssigned >= 1) {
                    return '<a href=#>' + record.data.countOfSequenceAssigned + '<a>';
                }
            }
        }
    }]
});
