/**
 * @author kuldeep yadav
 */
Ext.define('Academia.view.examinationcenters.attestationform.AttestationForm', {
	extend: 'Ext.form.FormPanel',
    alias: 'widget.attestationform',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    modal: true,
    standardSubmit : false,
    plugins : "formlabelrequired",
	    items: [{
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            width: 226,
	            labelAlign: 'top'
	        },
	        items: [{
		        	xtype: 'customcombobox',
		            name: 'evaluationGroupId',
		            itemId: 'evaluationGroupItemId',
		            store:'examinationcenters.evaluationgroup.EvaluationGroupForAttestationStore',
		            displayField:'code',
		            valueField:'id',
		            forceSelection:true,
		            typeAhead:true,
	//	            disabled : true,
		            fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
	//	            allowBlank:true
		            allowBlank:false
		        },{
		        	xtype: 'customcombobox',
		            name: 'studentType', 
		            itemId:'studentTypeId',
		            store: 'examinationcenters.evaluationgroup.StudentResultStatusEnumStore',
		            displayField: 'value',
		            valueField: 'id',
		            typeAhead: true,
		            forceSelection:true,
		            fieldLabel:getExaminationTranslation('STUDENT_TYPE'),
		            hidden:false
	            },{
	        		xtype: 'customcombobox',
					name:'program',
					itemId:'programItemId',
					store:'examinationcenters.evaluationgroup.EGProgramForAttestationStore',
					fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'name',
					minChars:3,
					width:226,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					allowBlank:true,
					disabled:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
	            }]
	    },
	    {
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            width: 226,
	            labelAlign: 'top'
	        },
	        items: [{
	        	xtype: 'customcombobox',
	            name: 'batchId',
	            itemId:'batchIdItemId',
	            store:'examinationcenters.evaluationgroup.EGBatchForAttestationStore',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            typeAhead:true,
	            minChars:3,
	            disabled : true,
	            fieldLabel:getExaminationTranslation('BATCH'),
	            allowBlank:true
            },{
		        	xtype: 'customcombobox',
		            name: 'periodId',
		            itemId: 'periodItemId',
		            store:'examinationcenters.manageEvaluation.evaluationgroup.EGPeriodStore',
		            displayField:'value',
		            valueField:'id',
		            forceSelection:true,
		            typeAhead:true,
		            disabled : true,
		            fieldLabel:getExaminationTranslation('PERIOD'),
	//	            allowBlank:true
		            allowBlank:true
		        }]
	    },
	    {
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            width: 226,
	            labelAlign: 'top'
	        },
	        items: [{
				xtype: 'customcombobox',
				name:'admissionId',
				itemId:'admissionItemId',
				store: 'examinationcenters.evaluationgroup.ExamAttestationStudentStore',//'examinationcenters.evaluationgroup.studentcovered.StundentNameCombo',
				fieldLabel: getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				width: 460,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				allowBlank:true,
				disabled:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
	    },
	    {
		    xtype: 'fieldcontainer',
	        width:'100%',
	        cls:'windowBtnPos',
	        style:{
	        	marginTop:'15px !important'
	        },
	        items: [ {
	            xtype: 'button',
	            itemId:'searchBtn',
	            text: getCommonTranslation('SEARCH'),
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind:true
	        },{
	            xtype: 'button',
	            text: getCommonTranslation('RESET'),
	            itemId:'resetBtn',
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        },{
	            xtype: 'button',
	            text: getExaminationTranslation('GENERATE_ATTESTATION_FORM'),
	            itemId:'btnGenerateAttestation',
	            ui: 'CustomBtnThird',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind:true
	       }]
	   }]
});