/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.centerunavailability.CenterUnavailabilityForm', {
	    extend : 'Ext.form.FormPanel',
	    alias: 'widget.centerunavailabilityform',
	    modal: true,
	    autoScroll:true,
        bodyPadding: '10 10 10 10',
        frame:true,
        layout: {
            type: 'vbox'
        },
        defaults: {
            labelAlign: 'top',
            autoScroll:true
        },
        style:{
        	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
        },
        plugins:"formlabelrequired",
        standardSubmit: false,
        items: [{
           	xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults :{
    			width: 226,
    			labelAlign:'top'
    		},
    		items:[{
    			    xtype:'hidden',
    			    name:'id'
	    		},{
		           /* xtype: 'customcombobox',
		            name: 'centerType',
		            itemId:'centerTypeItemId',
		            fieldLabel: getExaminationTranslation('CENTER_TYPE'),
		            store: 'examinationcenters.CenterType',
		            displayField: 'value',
		            valueField: 'id',
		            typeAhead: true,
		            forceSelection: true,
		            allowBlank: false
		        },{*/
	    			 xtype: 'customcombobox',
				     name:'centerCode',
				     store:'examinationcenters.centerunavailability.CenterCode',
				     fieldLabel: getExaminationTranslation('CENTER_NAME'),
				     displayField : 'value',
				     valueField : 'id',
				     forceSelection: true,
				     allowBlank: false,
				    // disabled:true
    		     }]
    	},{
        	xtype      : 'radiogroup',
            fieldLabel : getExaminationTranslation('UNAVAILABLE_FOR'),
            name:'unavailableFor',
            itemId:'unavailableForItemId',
            defaults: {
                width: 226
            },
            layout: 'hbox',
            items:[{ 
            	boxLabel: getExaminationTranslation('SPECIFICTIMES_SLOT'), 
            	name: 'days', 
            	inputValue: false,
            	checked:true
            },{ 
            	boxLabel: getExaminationTranslation('FOR_DAYS'), 
            	name: 'days', 
            	inputValue: true
            }]
        },{
        	xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
            	xtype: 'datefield',
                name: 'fromDate',
            	itemId:'fromdateItemId',
            	minValue: new Date(),
                fieldLabel:getExaminationTranslation('FROM_DATE'),
              //--submitFormat: CONSTANTS.DISPLAY_DATE_FORMAT,
                allowBlank:false,
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                }
              },{
            	xtype: 'datefield',
                name: 'tillDate',
            	itemId:'tillDateItemId',
            	minValue: new Date(),
            	//--submitFormat: CONSTANTS.DISPLAY_DATE_FORMAT,
                fieldLabel:getExaminationTranslation('TILL_DATE'),
                allowBlank:false,
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                }
            }]
        },{
			xtype:'fieldcontainer',
			itemId:'timePanelId',
			items:[{
				xtype : 'fieldcontainer',
				width: '100%',
				itemId:'timeContainer',
				layout : 'hbox',
				defaults: {
	                width: 226,
	                labelAlign: 'top'
	            },
				items : [{
					xtype:'hidden',
					name:'timeId'
				},{
					xtype : 'timefield',
					name : 'fromTime',		
					itemId : 'fromTime',			
					fieldLabel:getExaminationTranslation('FROM_TIME'),
					format:'g:i A',
					vtype: 'timerange',
					allowBlank:false,
					listeners:{
						change:function(obj,val){
							obj.nextSibling().setMinValue(val);
						},
						blur: function() {
							assertTimeValue(this);
						}
					}
				},{
					xtype : 'timefield',
					name : 'toTime',		
					itemId : 'toTime',			
					fieldLabel:getExaminationTranslation('TILL_TIME'),
					format:'g:i A',
					vtype: 'timerange',
					allowBlank:false,
					listeners:{
						change:function(obj,val){
							obj.previousSibling().setMaxValue(val);
						},
						blur: function() {
							assertTimeValue(this);
						}
					}
				},{
					xtype: 'button',
					itemId: 'timeBtn',
					cls: 'CustomBodyBtnSettings',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD'),
					style:{
						marginTop:'30px'
					}
				 } 
				]}
			]},{
        	xtype: 'fieldcontainer',
            width:'100%',
            items: [{
                xtype: 'button',
                action : 'Submit',
                text: getCommonTranslation('SAVE'),
                itemId: 'btnSave',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('RESET'),
                itemId: 'btnReset',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
});