/**
 * @author Pankaj Sisodiya     
 */
Ext.define('Academia.view.examinationcenters.evalresultlisting.EvaluationProgramLevelGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.evaluationProgramLevelGrid',  
    store: 'examinationcenters.evalresultlisting.EvaluationProgramLevelStore', 
  title: getExaminationTranslation('PROGRAM'),
    border: true,
    isGridConfigurable: true,
	enableColumnHide: false,    
    refreshStoreData: true,
    deferEmptyText: false,
    cls: 'grid-bottom-border',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    }, 
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        itemId: 'dockedItemsItemId',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'examinationcenters.evalresultlisting.EvaluationProgramLevelStore',      
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [{
    	xtype: 'button',
    	text: getCommonTranslation('APPROVE'),
    	tooltip :getCommonTranslation('APPROVE'),
    	hidden: true 
    }],
    columns: [{ 
			        header: getCommonTranslation('PROGRAM_ID'),   
			        dataIndex: 'programId',
			        flex: 1,
			        hidden: true     
			    },
			    {
			        header: getCommonTranslation('BATCH_ID'),
			        dataIndex: 'batchId',
			        flex: 1,
			        hidden: true
			    },
                {
                    header: getCommonTranslation('ADMISSION_NO'),
                    dataIndex: 'admissionCode',
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('STUDENT_ID'),
                    dataIndex: 'studentCode',
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('STUDENT_NAME'),
                    dataIndex: 'studentName', 
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('FIRST_NAME'),
                    dataIndex: 'firstName',
                    flex: 1,
                    hidden: true
                },
                {
                    header: getCommonTranslation('MIDDLE_NAME'),
                    dataIndex: 'middleName',
                    flex: 1,
                    hidden: true
                },
                {
                    header: getCommonTranslation('LAST_NAME'),
                    dataIndex: 'lastName',
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('PROGRAM_NAME'),
                    dataIndex: 'programName', 
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('BATCH_NAME'),
                    dataIndex: 'batchName', 
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('PROGRAM_PERIOD_NAME_NEW'),
                    dataIndex: 'periodName',  
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('SECTION_CODE'),
                    dataIndex: 'sectionName',
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('EFFECTIVE_MARKS_FROM'),
                    dataIndex: 'outOfMarks', 
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('OBTAINED_MARKS'),
                    dataIndex: 'obtainedMarks',    
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('PERCENTAGE'),
                    dataIndex: 'percentage',    
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('CGPA'),
                    dataIndex: 'cgpa',    
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('SECTION_WISE_PROGRAM_RANK'),
                    dataIndex: 'sectionRank',    
                    flex: 1,
                    hidden: false
                } ,
                {
                    header: getCommonTranslation('STATUS'),
                    dataIndex: 'status',    
                    flex: 1,
                    hidden: true,
			        renderer: function (value, meta, record) {
				    	if(value == 'PASS') {
				    		return "<font color='green'>"+getExaminationTranslation(value)+"</font>";  
						}else if(value =='FAIL'){
							return "<font color='red'>"+getExaminationTranslation(value)+"</font>";  
						}
						
					}
                } ,
                {
                    header: getCommonTranslation('ADMISSION_ID'),
                    dataIndex: 'admissionId',    
                    flex: 1,
                    hidden: true
                }  ,
                {
                    header: getCommonTranslation('PROGRAM_RANK'),
                    dataIndex: 'programRank',    
                    flex: 1,
                    hidden: false
                }        
            ]
}); 