/**
 * @author sumit meena
 */
Ext.define('Academia.view.examinationcenters.evaluationgroup.studentcovered.StudentCoveredFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.studentcoveredfilter',
    autoScroll: false,
    frame: false,
    border:false,
	cls:'customSearchPanel',
    items: [{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
        		xtype: 'customcombobox',
        		name: 'studentId',
        		itemId : 'studentId',
    			fieldLabel:getExaminationTranslation('STUDENT_NAME'),
    			store:'examinationcenters.evaluationgroup.studentcovered.StundentNameCombo',
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'name',
    			minChars:3,
    			typeAhead:false,
    			forceSelection:true,
    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    			enableKeyEvents  : 'true',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                triggerAction: '',
    			hideTrigger:false,
    			  listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                        '{value}' +
    	                    '</div>';
    	                }
    	            }
            },{
	        	xtype: 'customcombobox',
	            name: 'courseId',
	            itemId : 'courseItemId',
	            store:'examinationcenters.evaluationgroup.studentcovered.StudentCoveredCourseCombo',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            typeAhead:true,
	            minChars:3,
	            queryParam:'textSearch',
	            fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}


			},{
	        	xtype: 'customcombobox',
	            name: 'courseVariant',
	            itemId:'courseVariantItemId',
	            fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
	            store:'examinationcenters.evaluationgroup.FilterForCV',
	            displayField:'value',
	            valueField:'id',
	            width:226,
	            queryParam:'searchText',
     			minChars:3,
     			typeAhead:false,
     			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
     			enableKeyEvents  : 'true',
     			hideTrigger:false,
     			forceSelection:true,
     			width:226,
     			disabled:true,
//     			allowBlank:false,
     			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
     			listConfig: {
     				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
     				loadingText: getCommonTranslation('SEARCHING'),
     				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
     				getInnerTpl: function() {
     					return '<div class="search-item">' +
     					'{value}' +
     					'</div>';
     				}
     			}
	        }]
    },{
	    xtype: 'fieldcontainer',
	    layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
			xtype: 'customcombobox',
			name:'periodId',
			itemId:'periodItemId',
			store:'examinationcenters.evaluationgroup.FilterForPeriod',
			fieldLabel: getExaminationTranslation('PERIOD'),
			displayField: 'value',
			valueField: 'id',
			typeAhead: true,
			forceSelection: true,
			disabled:true,
			allowBlank: false
		},{
			xtype: 'customcombobox',
			name:'sectionId',
			itemId:'sectionItemId',
			store:'examinationcenters.evaluationgroup.FilterForSections',
			fieldLabel: getExaminationTranslation('SECTION'),
			displayField: 'value',
			valueField: 'id',
			typeAhead: true,
			forceSelection: true,
			disabled:true,
			allowBlank: false
		},{
			xtype: 'customcombobox',
			name: 'evaluationPlanId',
			itemId:'evaluationPlanItemId',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			store:'examinationcenters.evaluationgroup.FilterForPlan',
			valueField: 'id',
			displayField: 'value',
			queryParam:'searchText',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			hideTrigger:false,
			allowBlank: false,
			disabled:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
   },{
	    xtype: 'fieldcontainer',
        width:'100%',
        cls:'windowBtnPos',
        items: [{
            xtype: 'button',
            itemId:'searchBtn',
            text: getCommonTranslation('SEARCH'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId:'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
   }]
});