/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evaluationresult.EvaluationResultCourseFilter', {
	extend : 'Ext.form.FormPanel',
	alias: 'widget.evaluationresultcoursefilter',
	autoScroll: false,
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items:[{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			

        	xtype: 'customcombobox',
			name:'courseId',
			itemId:'courseItemId',
			store: 'examinationcenters.reports.ExaminationReportCourseStore',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			allowBlank:false,
			width: 460,
			forceSelection:true,
			disabled:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
			/*
			xtype: 'customcombobox',
			name: 'courseId',
			itemId: 'courseItemId',
			fieldLabel:getExaminationTranslation('COURSE'),
			store:'course.CourseComboStore',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			allowBlank:false*/
		},{
			xtype: 'customcombobox',
			name: 'variantId',
			itemId: 'variantItemId',
			fieldLabel:getExaminationTranslation('VARIANT'),
			store:'attendance.VariantMappedToPlan',
            displayField:'value',
            valueField:'id',
			forceSelection:true,
			typeAhead:true,
			disabled:true,
			allowBlank:false,
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [
			{
				xtype: 'customcombobox',
				name: 'evaluationLevel',
				itemId: 'evaluationLevel',
				fieldLabel:getExaminationTranslation('EVALUATION_LEVEL'),
				store:'examinationcenters.evaluationresult.EvaluationLevel',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				//disabled:true
				allowBlank:false
			},{
			xtype: 'customcombobox',
			name: 'programId',
			itemId: 'programItemId',
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store:'examinationcenters.repetitioncompletion.RnCProgramsByVariantNAcadLocId',
			displayField:'valueCode',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			queryParam:'name',
			disabled:true
			
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId: 'batchItemId',
			fieldLabel:getExaminationTranslation('BATCH'),
			store:'common.CurrentBatchStore',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			disabled:true
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			fieldLabel:getExaminationTranslation('PERIOD'),
			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			disabled:true
			},
		    {
			xtype: 'multiselectcombofield',
			name: 'sectionId',
			itemId: 'sectionItemId',
			width: 460,
			fieldLabel: getExaminationTranslation('SECTION'),
			store:'attendance.SectionAndFacultyByPeriodID',
			displayField:'sectionCode',
			valueField:'sectionId',
			maxLength:10000,
			autoloadStore: false,
			forceSelection:true,
			typeAhead:true,
			disabled:true,
			cls:'placementProgramMultiselect'
		}]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		cls:'windowBtnPos',
		items: [{
			xtype: 'button',
			itemId:'searchBtn',
			text: getCommonTranslation('SEARCH'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});