/**
 * @Author Raghavendra.Soni
 */
Ext.define('Academia.view.examinationcenters.evalution.evaluationDetail.EligibleProgramsTabGrid',{ 
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.eligibleprogramstabgrid',
	border:true,
	title:getExaminationTranslation('ELIGIBLE_PROGRAMS_LIST'),
	itemId : 'eligibleProgramsTabGridItemId',
	autoScroll: true,
	height:370,
	store : 'examinationcenters.evaluation.EligibleProgramsTabStore',
	initComponent: function() {
		var grid=this;       
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);  
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selType:'checkboxmodel',
	selModel: {
		checkOnly : true, // checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
		allowDeselect: false
	},
	tbar: [{
		xtype: 'panel',
		layout:'hbox',
		items:[{
			xtype: 'button',
			itemId: 'btnSave',
			tooltip: getCommonTranslation('SAVE'),
			text:  getCommonTranslation('SAVE'),
        	ui: 'CustomBtnSubmit'
		}, {
			xtype:'textfield',
			emptyText: getCommonTranslation('ENTER_CHAR_TO_AUTO_SEARCH'),
			width: 300,
			style: 'margin-left:5px !important;',
			name:'autoSearchField',
			itemId:'autoSearchFieldItemId',
			enableKeyEvents: true
		}]
	}],
	columns : [{
		header : getProgramandcourseTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1
	},{
		header : getExaminationTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1
	},{
		header : getExaminationTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1
	},{
		header : getExaminationTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1
	}],
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			displayInfo: true,
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
			store: 'examinationcenters.evaluation.EligibleProgramsTabStore'
		}]
	}],
});

