/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evalution.evaluationPlanHierarchy.CreateGroupGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.creategroupgrid',
    store: 'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationStudentList',
    border: true,
    cls:'horizontal-scrolling-fix', 
    autoScroll: false,
    frame:false,
    selType:'checkboxmodel',
    viewConfig: {
        stripeRows: true
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'pagingtoolbar',
           // store: 'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationStudentList',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],

    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }, {
    	xtype: 'button',
        text: getCommonTranslation('SAVE'),
        itemId: 'btnGridSubmit',
        //ui: 'CustomBtnSubmit',
        scale: CONSTANTS.BUTTONSIZE
    }],
    columns: [{
        header: getExaminationTranslation('GROUP_NO'),
        dataIndex: 'groupNumber',
        flex:.4,
        sortable:true
    },{
        header: getExaminationTranslation('STUDENT_NAME'),
        dataIndex: 'firstName',
        flex:.4,
        sortable:true
    }, {
        header: getExaminationTranslation('DATE'),
        dataIndex: 'plannedDate',
        flex:.3,
        sortable: true,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getExaminationTranslation('TIME'),
        dataIndex: 'plannedTime',
        flex:.3,
        sortable: true,
        renderer:function(value, record){
        	return timeRender(value);
        }
    }]
});