/**
 * @author Bhanu PS
 */
var examinationStaffGridStore = Ext.create('Academia.store.examinationcenters.examstaffallocation.ExaminationStaffGrid');
Ext.define('Academia.view.examinationcenters.examstaffallocation.StaffAllocatonGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.staffallocatongrid',
    store : examinationStaffGridStore,
    title : getExaminationTranslation('EXAMINATION_STAFF_ALLOC'),
    border: true,
	frame:false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : examinationStaffGridStore,
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
	 isGridConfigurable:true,
	 enableColumnHide: false,
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	 tbar: [{
	        xtype: 'button',
	        itemId: 'addBtn',
	        tooltip: getCommonTranslation('ADD'),
	        glyph: ICONGLYPH.ADDGLYPH
	    }/*, {
	        xtype: 'button',
	        itemId: 'edt',
	        tooltip: getCommonTranslation('EDIT'),
	        glyph: ICONGLYPH.EDITGLYPH
	   }, {
	        xtype: 'button',
	        itemId: 'searchResultGridBtnView',
	        tooltip: getCommonTranslation('VIEW'),
	        iconCls: 'view-icon'
   }*/, {
	        xtype: 'button',
	        itemId: 'btnDelete',
	        cls: 'CustomToolbarBtnReject',
	        tooltip: getCommonTranslation('DELETE'),
	        glyph: ICONGLYPH.DELETEGLYPH
	    }],
	columns: [{
		header:  getCommonTranslation('EVALUATION_GROUP'),
		dataIndex: 'evaluationGroupName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_NAME'),
		dataIndex: 'courseName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.1,
		sortable:true
	},{
		header: getCommonTranslation('DETAIL_SEQUENCE'),
		dataIndex: 'eventName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('CENTER'),
		dataIndex: 'examCenterName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('INVIGILATOR'),
		dataIndex: 'staffName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('EXAMP_DATE'),
		dataIndex: 'evaluationDateStr',
		flex:.1,
		sortable:true,
		renderer: function(value) {   
		    if (!value || value === null || value.toString().toLowerCase().includes('null')) {
		        return 'NA';
		    }else{
		    	return value;
		    }} 
	},{
		header:getCommonTranslation('TIME_SLOT'),
		dataIndex: 'timeslot',
		flex:.1,
		sortable:true ,/*,
		renderer:function(value, record){
			if(record.record.data.timeFrom!=null){
				return timeRender(record.record.data.timeFrom)+" - "+(timeRender(record.record.data.timeTo));
			}else{
				return 'NA';
			}
        	
        }*/
		
		renderer: function(value) {   
		    if (!value || value === null || value.toString().toLowerCase().includes('null')) {
		        return 'NA';
		    }else{
		    	return value;
		    }
		
	}
	}]
});
