/**
 * kuldeep yadav
 */
Ext.define('Academia.view.examinationcenters.generatehallticket.GenerateHallTicketGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.generatehallticketgrid',
	store: 'examinationcenters.evaluationgroup.GenerateHallTicketGridStore',
	title: getExaminationTranslation('HALL_TICKETS'),
	border: true,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selType:'checkboxmodel',
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'examinationcenters.evaluationgroup.GenerateHallTicketGridStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);
	},
	tbar : [{
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		defaults: {
			labelAlign:'top',
		},
		items:[{
			xtype: 'button',
			itemId: 'btnApproveId',
			disabled:true,
			text:getExaminationTranslation('APPROVE'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}]
	},{
		xtype: 'button',
		itemId: 'btnWithdrawnId',
		text: getExaminationTranslation('WITHDRAWN'),
		disabled:true,
	}, {
		xtype: 'button',
		itemId: 'btnHallTicketRegenerationId',
		text: getExaminationTranslation('REGENERATE_HALL_TICKET'),
		disabled:true,
	}, {
		xtype: 'button',
		itemId: 'btnPublishHallTicket',
		text: getExaminationTranslation('PUBLISH_HALL_TICKET'),
		disabled:true,
	},'->',{
		xtype: 'button',
		itemId: 'btnDownloadAllHallTickets',
		disabled:true,
		text:getExaminationTranslation('DOWNLOAD_ALL_HALL_TICKETS')
	}],
	columns: [{
		header: getCommonTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.3,
		sortable:true
	},{
		header: getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.4,
		sortable:true
	},{
		header: getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.4,
		sortable:true
	}, {
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.3,
		sortable: true
	}, {
		header: getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.3,
		sortable: true
	}, {
		header: getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.3,
		sortable: true
	}, {
		header: getCommonTranslation('EVALUATION_GROUP'),
		dataIndex: 'evaluationGroupCode',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('TOTAL_OUTSTANDING'),
		dataIndex: 'totalOutstanding',
		flex:.3,
		sortable: true,
		renderer: function(currency) {
			if(!isNullOrEmpty(currency)) {
				return "INR. "+currencyRender(currency);
			} else {
				return "<b>N/A</b>";
			}
		}
	},  {
		header: getCommonTranslation('APPLICATION_STATUS'),
		dataIndex: 'applicationStatus',
		flex:.3,
		sortable: true,
		renderer: function(value){
			if(!isNullOrEmpty(value))
				return capitaliseEnumValue(value);
		}
	}, {
		header: getExaminationTranslation('HALL_TICKET_NO'),
		dataIndex: 'hallticket',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			if(value!=null) {
				return '<a href=#>'+value+'</a>';
			}
		}
	}, {
		header: getExaminationTranslation('CENTER_ALLOTED'),
		dataIndex: 'centerAllotted',
		flex:.3,
		sortable: true,
		renderer: function(value){
			if(!isNullOrEmpty(value)){
				return capitaliseEnumValue(value);
			}

		}
	},{
		header: getExaminationTranslation('NON_APPROVAL_REASON'),
		dataIndex: 'reasonForNonApproval',
		flex:.3,
		sortable: true,
		renderer: function(value){
			if(!isNullOrEmpty(value)) {
				return getExaminationTranslation(value);
			}

		}
	},{
		header: getExaminationTranslation('PUBLISH_HALL_TICKET'),
		dataIndex: 'isPublishHallTicket',
		flex:.3,
		renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.financeHoldStatus) && (record.data.financeHoldStatus=="Hold" )){
					return '<sapn style=\'color:red\'>Hold for Student</span>';
				}else if(record.data.isPublishHallTicket){
					return '<sapn>Published</span>';
				} else{
					return '<sapn style=\'color:red\'>Pending</span>';
				}
			
		}
	}]
});