/**
 * @raghavendra.soni
 * This screen is copy of ManageEvalResultGridWindow and new enhancement/functionality is added in this screen 
 */
Ext.define('Academia.view.examinationcenters.manageEvaluation.ManageEvalResultGridWindowNew', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.manageevalresultgridwindownew',
	modal:true,
	autoScroll:false,
	items: [{
		xtype:'form',
		items:[{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 420,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype:'hidden',
				name:'editViewButton',
				itemId:'editViewButton'
			},{
				xtype:'displayfield',
				name:'course',
				fieldLabel:'<b>'+getExaminationTranslation('COURSE')+'</b>'
			},{
				xtype:'displayfield',
				name:'courseVariant',
				fieldLabel:'<b>'+getExaminationTranslation('COURSE_VARIANT')+'</b>'
			},{
				xtype:'displayfield',
				name:'section',
				fieldLabel:'<b>'+getExaminationTranslation('SECTION')+'</b>'
			},{
				xtype:'hidden',
				name:'courseId',
			}]
		},
		{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 420,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'evalPlanNo',
				fieldLabel:'<b>'+getExaminationTranslation('EVALUATION_PLAN')+'</b>'
			},{
				xtype:'displayfield',
				name:'detailSequence',
				fieldLabel:'<b>'+getExaminationTranslation('DETAIL_SEQUENCE')+'</b>'
			},{
				xtype:'displayfield',
				name:'weightage',
				fieldLabel:'<b>'+getExaminationTranslation('WEIGHTAGE')+'</b>'
			}]
		},
		{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 420,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'minPassMarks',
				fieldLabel:'<b>'+getExaminationTranslation('MIN_PASSING_MARKS')+'</b>'
			},{
				xtype:'displayfield',
				name:'maxMarks',
				itemId: 'maxMarksDisplayFieldItemId',
				fieldLabel:'<b>'+getExaminationTranslation('MAXIMUM_PASSING_MARKS')+'</b>'
			},{
				xtype:'displayfield',
				name:'effectiveWeightage',
				fieldLabel:'<b>'+getExaminationTranslation('EFFECTIVE_WEIGHTAGE')+'</b>'
			},{
				xtype:'hidden',
				name:'marksOrGrade',
				itemId: 'marksOrGrade',
			}]
		}]
	},{
		xtype: 'grid',
		itemId:'gradeTypeMarkEntryGridItemId',//'ManageEval',
		frame:false,
		border:true,
		autoScroll:true,
		cls:'markEntryGridCLS',
		hidden: true,
		//emptyText:getCommonTranslation('SCAN_ID_WAS_NOT_FOUND'), 
		store:'examinationcenters.manageEvaluation.ManageEvaluationResult',
		selType:'checkboxmodel',
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		title: '&nbsp;',
		selModel: {
			checkOnly : true,
			allowDeselect: false
		},
		tbar:[{
			xtype: 'container',
			width: '100%',
			layout: {
				type: 'hbox'
			},
			items: [
				{
					xtype: 'button',
					text: getExaminationTranslation('SET_DEFAULT_GRADE'),
					itemId: 'defaultGradeBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE,
				},{
					xtype: 'button',
					itemId: 'btnEnterRemark',
					ui: 'CustomBtnCancel',
					disabled: true,
					scale: CONSTANTS.BUTTONSIZE,
					tooltip: getExaminationTranslation('ENTER_REMARK'),
					text:getExaminationTranslation('ENTER_REMARK'),
				},{
					xtype: 'button',
					text: getCommonTranslation('SAVE'),
					itemId: 'saveBtnNew',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE
				},
			        {
			        	xtype: 'button',
			        	text: getExaminationTranslation('SUBMIT'),
			        	itemId: 'submitBtnNew',
			        	ui: 'CustomBtnCancel',
			        	scale: CONSTANTS.BUTTONSIZE,
			        	disabled:true,
			        	hidden:true
			        },{
			        	xtype: 'button',
			        	text: getExaminationTranslation('RESET'),
			        	itemId: 'resetGridBtnNew',
			        	ui: 'CustomBtnCancel',
			        	scale: CONSTANTS.BUTTONSIZE,
			        	disabled:true
			        },{
			        	xtype:'textfield',
			        	emptyText: getCommonTranslation('ENTER_CHAR_TO_AUTO_SEARCH'),
			        	width: 300,
			        	name:'examUniqueCodeText',
			        	itemId:'examUniqueCodeTextId',
			        	cls: 'SearchTextFieldWithSmallHeader',
			        	hidden:true,
			        	enableKeyEvents: true
			        }, {
		        	    xtype: 'button',
		        	    itemId: 'checkHistoryBtnEditGrade',
		        	    tooltip: getExaminationTranslation('CHECK_HISTORY'),
		        	    text: getExaminationTranslation('CHECK_HISTORY'),
		        	    ui: 'CustomBtnCancel',
			        	scale: CONSTANTS.BUTTONSIZE,
		        	    disabled: true
		        	}]
		}],
		columns: [{
			header: getExaminationTranslation('S_NO'),
			xtype: 'rownumberer',
			sortable: false,
			align:'center',
			flex:.1,
			locked: false
		}/*,{
			header: getExaminationTranslation('ID'),
			dataIndex: 'admissionId',
			flex:.1,
			sortable:true,
			hidden:true
		}*/,{
			header: getExaminationTranslation('STUDENT_ID'),
			dataIndex: 'studentId',
			flex:.1,
			sortable:true
		},{
			header: getExaminationTranslation('ADMISSION_ID'),
			dataIndex: 'admissionCode',
			flex:.1,
			sortable:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.admissionCode)){
					return value;
				}
			}
		},{
	        header: getExaminationTranslation('NATIONAL_ID'),
	        dataIndex: 'nationalID',
	        flex:.1,
	        sortable: true,
	        hidden:true	        
	    },{
			header: getExaminationTranslation('STUDENT_NAME'),
			dataIndex: 'studentName',
			flex:.2,
			sortable: true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.studentName)){
					return value;
				} else {
					return '<span style=\'color:red\'>N/A</span>'
				}
			}
		},
		{
	        header: getExaminationTranslation('FIRST_NAME'),
	        dataIndex: 'firstName',
	        flex:.1,
	        renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.firstName)){
					return value;
				}
			}
	    },{
	        header: getExaminationTranslation('MIDDLE_NAME'),
	        dataIndex: 'middleName',
	        flex:.1,
	        sortable: true,
	        renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.middleName)){
					return value;
				}
			}
	    },{
	        header: getExaminationTranslation('LAST_NAME'),
	        dataIndex: 'lastName',
	        flex:.1,
	        sortable: true,
	        renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.lastName)){
					return value;
				}
			}
	    },{
			header: getExaminationTranslation('UNIQUE_CODE'),
			dataIndex: 'examUniqueCode',
			flex:.1,
			sortable:true,
			hidden:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.examUniqueCode)){
					return value;
				} else {
					return '<span style=\'color:red\'>N/A</span>'
				}
			}
		},{
	        header: getExaminationTranslation('HALL_TICKET_NO'),
	        dataIndex: 'hallticket',
	        flex:.1,
	        sortable:true,
	        hidden:true,
	    },{
			header: getExaminationTranslation('Grade'),
			dataIndex: 'finalGrade',
			flex:.1,
			sortable: true,
			editor: {
				xtype: 'customcombobox',
				name:'finalGrade',
				itemId:'finalGrade',
				store:'gradeMaster.GradeGroupMapping',
				valueField:'grade',
				displayField:'grade',
				editable:false,
				listeners: {
					change: function(field, nval) {
						var rec = this.up('grid').findPlugin('cellediting').context.record;
						if(!isNullOrEmpty(nval)) {
							field.up('grid').getSelectionModel().select(rec);
							field.up('grid').down('#resetGridBtnNew').setDisabled(false);
						}
						else {
							field.up('grid').getSelectionModel().deselect(rec);
						}
					}
				}
			},
			renderer:function(val,rec){
				if(isNullOrEmpty(val)){
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_SELECT');
				}else{
					return rec.record.data.finalGrade;
				}
				return rec.record.data.finalGrade;
			}
		},{
			header: getExaminationTranslation('INTERNAL_REMARK'),
			dataIndex: 'finalDescription',
			flex:.1,
			sortable: true,
			/*editor: {
				xtype: 'textfield',
				name:'finalDescription',
				itemId:'remark',
			},
			renderer:function(val,rec){
				if(isNullOrEmpty(val)){
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}else{
					return val;
				}
			}*/
			editor: {
				xtype: 'customcombobox',
				name:'finalDescription',
				itemId:'remark',
				store:Ext.create('Academia.store.eventlevelremark.EventLevelRemarkNameStore'),
				valueField : 'remarkName', 
				displayField : 'remarkName',
				editable:true,
				maxLength:255,
				listConfig: { 
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.maxWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{courseCodeName}' +
						'</div>';
					}
				}
			},
			renderer:function(val,rec){
				if(isNullOrEmpty(val)){
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}else{
					return val;
				}
			}
		}],
		plugins: [{
			ptype : 'cellediting',
			clicksToEdit: 1,
			listeners: {
	            beforeedit: function(ed,e){
	            	e.grid.getSelectionModel().deselectAll();
	            	if(ed.grid.viewMode == 'VIEW') {
	            		return false;
	            	}
	            },
	            edit: function(ed,e) {
	            	var disabled = true;
	            	Ext.each(selected, function(currentSelected){
	            		if(!isNullOrEmpty(currentSelected.data.totalMarks) || !isNullOrEmpty(currentSelected.data.penaltyMarks) || !isNullOrEmpty(currentSelected.data.finalMarks) || !isNullOrEmpty(currentSelected.data.finalGrade) || !isNullOrEmpty(currentSelected.data.finalDescription)){
	            			disabled = false;
	            		}
	            	});
	            	grid.view.up().down('#resetGridBtnNew').setDisabled(disabled);
	            	grid.view.up().down('#btnEnterRemark').setDisabled(!selected.length);
	            }
	        }
		}]
	},{
		xtype: 'grid',
		itemId:'markTypeMarkEntryGridItemId',//'ManageEval',
		frame:false,
		border:true,
		autoScroll:true,
		cls:'markEntryGridCLS',
		hidden: true,
		store:'examinationcenters.manageEvaluation.ManageEvaluationResult',
		selType:'checkboxmodel',
		//emptyText:getCommonTranslation('SCAN_ID_WAS_NOT_FOUND'),
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		title: '&nbsp;',
		selModel: {
			checkOnly : true,
			//allowDeselect: false
			mode: 'MULTI',
			toggleOnClick: false
		},
		tbar:[{
			xtype: 'container',
			width: '100%',
			layout: {
				type: 'hbox'
			},
			items: [
				{
					xtype: 'button',
					text: getExaminationTranslation('SET_DEFAULT_MARKS'),
					itemId: 'defaultMarksBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE,
				},{
					xtype: 'button',
					itemId: 'btnEnterRemark',
					ui: 'CustomBtnCancel',
					disabled: true,
					scale: CONSTANTS.BUTTONSIZE,
					tooltip: getExaminationTranslation('ENTER_REMARK'),
					text:getExaminationTranslation('ENTER_REMARK'),
				},{
			        	xtype: 'button',
			        	text: getCommonTranslation('SAVE'),
			        	itemId: 'saveBtnNew',
			        	ui: 'CustomBtnSubmit',
			        	scale: CONSTANTS.BUTTONSIZE
			        },/*
			        {
			        	xtype: 'button',
			        	text: getExaminationTranslation('SUBMIT'),
			        	itemId: 'submitBtnNew',
			        	ui: 'CustomBtnCancel',
			        	scale: CONSTANTS.BUTTONSIZE,
			        	disabled:true,
			        	hidden:true
			        },*/{
			        	xtype: 'button',
			        	text: getExaminationTranslation('RESET'),
			        	itemId: 'resetGridBtnNew',
			        	ui: 'CustomBtnCancel',
			        	scale: CONSTANTS.BUTTONSIZE,
			        	disabled:true
			        },{
			        	xtype:'textfield',
			        	emptyText: getCommonTranslation('ENTER_CHAR_TO_AUTO_SEARCH'),
			        	width: 300,
			        	name:'examUniqueCodeText',
			        	itemId:'examUniqueCodeTextId',
			        	cls: 'SearchTextFieldWithSmallHeader',
			        	hidden:true,
			        	enableKeyEvents: true
			        }, {
		        	    xtype: 'button',
		        	    itemId: 'checkHistoryBtnEdit',
		        	    tooltip: getExaminationTranslation('CHECK_HISTORY'),
		        	    text: getExaminationTranslation('CHECK_HISTORY'),
		        	    ui: 'CustomBtnCancel',
			        	scale: CONSTANTS.BUTTONSIZE,
		        	    disabled: true
		        	}]
		}],
		columns: [{
			header: getExaminationTranslation('S_NO'),
			xtype: 'rownumberer',
			sortable: false,
			align:'center',
			flex:.1,
			locked: false
		}/*,{
			header: getExaminationTranslation('ID'),
			dataIndex: 'admissionId',
			flex:.1,
			sortable:true,
			hidden:true
		}*/,{
			header: getExaminationTranslation('STUDENT_ID'),
			dataIndex: 'studentId',
			flex:.1,
			sortable:true
		},{
			header: getExaminationTranslation('ADMISSION_ID'),
			dataIndex: 'admissionCode',
			flex:.1,
			sortable:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.admissionCode)){
					return value;
				} else {
					return '<span style=\'color:red\'>N/A</span>'
				}
			}
		},{
	        header: getExaminationTranslation('NATIONAL_ID'),
	        dataIndex: 'nationalID',
	        flex:.1,
	        sortable: true,
	        hidden:true	        
	    },{
			header: getExaminationTranslation('STUDENT_NAME'),
			dataIndex: 'studentName',
			flex:.2,
			sortable: true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.studentName)){
					return value;
				} else {
					return '<span style=\'color:red\'>N/A</span>'
				}
			}
		},
		{
	        header: getExaminationTranslation('FIRST_NAME'),
	        dataIndex: 'firstName',
	        flex:.1,
	        renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.firstName)){
					return value;
				}
			}
	    },{
	        header: getExaminationTranslation('MIDDLE_NAME'),
	        dataIndex: 'middleName',
	        flex:.1,
	        sortable: true,
	        renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.middleName)){
					return value;
				}
			}
	    },{
	        header: getExaminationTranslation('LAST_NAME'),
	        dataIndex: 'lastName',
	        flex:.1,
	        sortable: true,
	        renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.lastName)){
					return value;
				} 
			}
	    },{
			header: getExaminationTranslation('UNIQUE_CODE'),
			dataIndex: 'examUniqueCode',
			flex:.1,
			sortable:true,
			hidden:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.examUniqueCode)){
					return value;
				} else {
					return '<span style=\'color:red\'>N/A</span>'
				}
			}
		},{
	        header: getExaminationTranslation('HALL_TICKET_NO'),
	        dataIndex: 'hallticket',
	        flex:.1,
	        sortable:true,
	        hidden:true,
	    },{
			header: getExaminationTranslation('MARKS_OBTAIN'),
			dataIndex: 'totalMarks',
			flex:.1,
			sortable: true,
			editor: {
				xtype: 'numberfield',
				name:'totalMarks',
				minValue:0,
				maxValue:999,
				decimalPrecision:4,
				mouseWheelEnabled:false,
				keyNavEnabled: false,
				spinDownEnabled: false,
				spinUpEnabled: false, 
				hideTrigger: true,
				validator: function(val) {
					var rec = {
						record: this.up('grid').findPlugin('cellediting').context.record
					};
					val = parseFloat(val);
					if(!isNullOrEmpty(val)){
						
						var isRoundedCheck=rec.record.data.whetherRoundedMark;
						
						if (isRoundedCheck) {
						    // Check if val is a valid number and a float (i.e., has decimals)
						    if (!isNaN(val) && val % 1 !== 0) { 
						     var value=Math.round(val); 
							 this.setValue(value);   
							 return true;  
						    }
						}

						
						
						var maxPassingMarksValue = Ext.ComponentQuery.query('#maxMarksDisplayFieldItemId')[0].getValue();
						/*if(rec.record.data.penaltyMarks==null&&rec.record.data.graceMarks==null){
							rec.record.set("finalMarks",val);
						}*/
						/**
						 * This condition if user put zero then all calculation will be zero.
						 */
						/*if(val==0){
							rec.record.set("finalMarks",val);
						}*/
						if(!isNullOrEmpty(val) && maxPassingMarksValue<val && !isNullOrEmpty(maxPassingMarksValue)){
							Ext.app.gridRendered = false;
							showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('NET_MARKS_MAX_AWARD_WARNING_MSG'));
							//rec.record.set("totalMarks","");
							//view.up('grid').preventSave = true;
							this.suspendEvent('change');
							this.setValue('');
							this.resumeEvent('change');
							return "The maximum value for this field is" + this.maxValue;
						}else{
							return true;
						}
					}else{
						//rec.tdCls = 'gridInputCustomStyle'; 
						//rec.record.set("finalMarks","");
						return true;
					}
				}
			},
			renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				if(!isNullOrEmpty(val)){
					var maxPassingMarksValue = Ext.ComponentQuery.query('#maxMarksDisplayFieldItemId')[0].getValue();
					if(rec.record.data.penaltyMarks==null&&rec.record.data.graceMarks==null){
						rec.record.set("finalMarks",val);
					}
					/**
					 * This condition if user put zero then all calculation will be zero.
					 */
					if(val==0){
						rec.record.set("finalMarks",val);
					}
					if(!isNullOrEmpty(val) && maxPassingMarksValue<val && !isNullOrEmpty(maxPassingMarksValue)){
						Ext.app.gridRendered = false;
						showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('NET_MARKS_MAX_AWARD_WARNING_MSG'));
						rec.record.set("totalMarks","");
						view.up('grid').preventSave = true;
						return "";
					}else{
						return val;
					}
				}else{
					rec.tdCls = 'gridInputCustomStyle'; 
					rec.record.set("finalMarks","");
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			}
		},{
			header: getExaminationTranslation('PENALTY_MARKS'),
			dataIndex: 'penaltyMarks',
			flex:.1,
			sortable: true,
			editor: {
				xtype: 'numberfield',
				name:'penaltyMarks',
				minValue:0,
				maxValue:999,
				decimalPrecision:4,
				mouseWheelEnabled:false
			},
			renderer:function(val,rec){
				var data=rec.record.data;
				if(data.totalMarks>0){
					if(val!=null&&val>=0){
						if(data.totalMarks>val){
							
							if(!isNullOrEmpty(data.graceMarks)&& data.graceMarks>=0){
								var finalMarks=data.totalMarks-val;
								var finalMarksG=finalMarks+data.graceMarks;
								rec.record.set("finalMarks",finalMarksG.toFixed(4));
							}
							if(data.graceMarks==null){
								var finalMarks=data.totalMarks-val;
								rec.record.set("finalMarks",finalMarks.toFixed(4));
							}
						}else{
							rec.record.set("penaltyMarks",'');
							Ext.app.gridRendered = false;
							showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('TOTAL_PENALTY_MARKS_WARNING_MSG'));
							return getExaminationTranslation('CLICK_TO_ENTER');
						}
					}
				}
				if(isNullOrEmpty(val)){
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}else{
					return val;
				}
			}
		},{
			header: getExaminationTranslation('GRACE_MARKS'),
			dataIndex: 'graceMarks',
			flex:.1,
			sortable: true,
			editor: {
				xtype: 'numberfield',
				name:'graceMarks',
				minValue:0,
				maxValue:999,
				decimalPrecision:4,
				mouseWheelEnabled:false
			},
			renderer:function(val,rec){
				var maxPassingMarksValue = Ext.ComponentQuery.query('#maxMarksDisplayFieldItemId')[0].getValue();
				var data=rec.record.data;
				if(data.totalMarks>0){
					if(val!=null&&val>=0){
						if(data.penaltyMarks!=null && data.penaltyMarks>=0){
							var finalMarks=data.totalMarks-data.penaltyMarks;
							var finalMarksval=finalMarks+val;
							rec.record.set("finalMarks",finalMarksval.toFixed(4));
						}else{
							var finalMarksval=data.totalMarks+val;
							rec.record.set("finalMarks",finalMarksval.toFixed(4));
						}
					}
				}
				if(isNullOrEmpty(val)){
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}else{
					if(finalMarksval>maxPassingMarksValue){
						Ext.app.gridRendered = false;
						showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('NET_MARKS_MAX_AWARD_WARNING_MSG'));
						rec.record.set("graceMarks",'');
						rec.tdCls = 'gridInputCustomStyle'; 
						return getExaminationTranslation('CLICK_TO_ENTER');
					} else {
						return val;
					}
				}
			}
		},{
			header: getExaminationTranslation('NET_TOTAL_MARKS'),
			dataIndex: 'finalMarks',
			flex:.1,
			sortable: true,
			renderer:function(val,rec){
				var maxPassingMarksValue = Ext.ComponentQuery.query('#maxMarksDisplayFieldItemId')[0].getValue();
				if(!isNullOrEmpty(val) && Number(maxPassingMarksValue)<Number(val) && !isNullOrEmpty(Number(maxPassingMarksValue))){
					Ext.app.gridRendered = false;
					showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('NET_MARKS_MAX_AWARD_WARNING_MSG'));
					return "";
				}else{
					return val;
				}
			}
		},{
			header: getExaminationTranslation('INTERNAL_REMARK'),
			dataIndex: 'finalDescription',  
			flex:.1,
			sortable: true,
			editor: {
			xtype: 'customcombobox',
        	name:'remarkName',
        	itemId:'remarkNameItemId',
        	store:Ext.create('Academia.store.eventlevelremark.EventLevelRemarkNameStore'),
        	valueField : 'remarkName', 
        	displayField : 'remarkName',
        	editable:true,
        	maxLength:255,
			listConfig: { 
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.maxWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{courseCodeName}' +
						'</div>';
					}
				}
			},
			renderer:function(val,rec){
				if(isNullOrEmpty(val)){
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}else{
					return val;
				}
			}
		},{
			header: getExaminationTranslation('MAX_CAP_MARK'),
			dataIndex: 'maxCapMark',
			flex:.1,
			hidden:true,
			disable:true
		}],
		plugins: [{
			ptype : 'cellediting',
			clicksToEdit: 1,
			listeners: {
	            beforeedit: function(ed,e){
	            	//e.grid.getSelectionModel().deselectAll();
	            	if(ed.grid.viewMode == 'VIEW') {
	            		return false;
	            	}
	            	e.grid.getView().refresh();
	            	try {
						var editor = e.column.getEditor();
						if(e.record.get('whetherRemarkMandatory')) {
                        	editor.allowBlank = false;
                        	editor.allowOnlyWhitespace = false;
                        }
                        else {
                        	editor.allowBlank = true;
                        	editor.allowOnlyWhitespace = true;
                        }
					}
					catch(e) {}
	            },
	            edit: function (editor, e) {
	            	var grid = e.grid;
	            	var record = e.record;
	            	var store = grid.getStore();
	            	var nextRowIndex = store.indexOf(record) + 1;

	            	// Get the list of visible columns
	            	var visibleColumns = grid.columns.filter(function (col) {
	            		return col.isVisible(); // Filter out hidden columns
	            	});

	            	// Find the last visible column index
	            	var lastVisibleColumn = visibleColumns[visibleColumns.length - 1];
	            	var lastVisibleColumnIndex = visibleColumns.indexOf(lastVisibleColumn);
	            	var prevSelection = grid.getSelectionModel().getSelection();
	            	var nextRow = store.getAt(nextRowIndex);
	            	var cellEditingPlugin = grid.plugins[0];
	            	grid.getSelectionModel().suspendEvents();
	            	Ext.defer(function() {
		            	var activeEditor = cellEditingPlugin.getActiveEditor(); // Get the active editor
		            	var activePosition = cellEditingPlugin.context; // Get editor's position (row, column)
	            		grid.getSelectionModel().select(prevSelection, true);
	            		grid.getSelectionModel().resumeEvents();
	            		// If an editor was open, re-focus it
	            		if (activeEditor && activeEditor.field && activeEditor.field.inputEl) {
	                        activeEditor.field.inputEl.focus(); // Refocus input field directly
	                    }
	            	}, 100);
	            }
	        }
		}]
	}]
});