/**
 * @author Deepak.nigam
 */
Ext.define('Academia.view.examinationcenters.questionPaperBank.questionPaperBankGrid', {
    //extend: 'Ext.grid.Panel',
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.questionpaperbankgrid',
    store: 'examinationcenters.questionPaperBank.QuestionPaperGridStore',
    border: true,
    frame: false,
    isGridConfigurable: true,
    enableColumnHide: false,
    title: getExaminationTranslation('LIST_QUESTION_PAPERS'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'examinationcenters.questionPaperBank.QuestionPaperGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getExaminationTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getExaminationTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getExaminationTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        cls: 'windowBtnPos',
        defaults: {
            labelAlign: 'top'
        },
        items: [{
            xtype: 'button',
            itemId: 'btnSave',
            tooltip: getExaminationTranslation('SUBMIT'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            text: getExaminationTranslation('SUBMIT')
        }]
    }],
    columns: [{
        header: getCommonTranslation('PAPER_CODE'),
        dataIndex: 'paperCode',
        flex: 1,
        renderer: function (value, meta, record) {
            return "<a href=\'#\'>" + record.data.paperCode + "</a>";
        }
    }, {
        header: getCommonTranslation('ACADEMIC_TERM'),
        dataIndex: 'academicTerm',
        flex: 1
    }, {
        header: getCommonTranslation('EVALUATION_PLAN'),
        dataIndex: 'evaluationPlanName',
        flex: 1
    }, {
        header: getCommonTranslation('COURSE_CODE_NAME'),
        dataIndex: 'courseName',
        flex: 1
    }, {
        header: getCommonTranslation('ASSESSMENT_EVENT_NEW'),
        dataIndex: 'evaluationSequenceDetailName',
        flex: 1
    }, {
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex: 1
    }, {
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        flex: 1
    }, {
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex: 1
    }, {
        header: getCommonTranslation('USER_ASSIGNED'),
        dataIndex: 'assignedUserName',
        flex: 1
    }, {
        header: getCommonTranslation('PAPER_STATUS'),
        dataIndex: 'paperStatus',
        flex: 1,
        renderer: function (value, meta, record) {
            if (!isNullOrEmpty(value)) {
                if (record.data.paperStatus != undefined) {
                    return getCommonTranslation(record.data.paperStatus);
                }
            }
        }
    }, {
        header: getCommonTranslation('DATE_OF_ASSIGNMENT'),
        dataIndex: 'dateOfAssignment',
        flex: 1,
        renderer: function (value, meta, record) {
            if (isNullOrEmpty(value)) {
                return '-';
            } else {
                return dateRender(value);
            }
        }
    }, {
        header: getCommonTranslation('DUE_DATE'),
        dataIndex: 'dueDate',
        flex: 1,
        renderer: function (value, meta, record) {
            if (isNullOrEmpty(value)) {
                return '-';
            } else {
                return dateRender(value);
            }
        }
    }, {
        header: getCommonTranslation('SUBMISSION_DATE'),
        dataIndex: 'submissionDate',
        flex: 1,
        renderer: function (value, meta, record) {
            if (isNullOrEmpty(value)) {
                return '-';
            } else {
                return dateRender(value);
            }
        }
    }, {
        header: getCommonTranslation('SUBMITTED_BY'),
        dataIndex: 'submittedByName',
        flex: 1
    }, {
        header: getCommonTranslation('ASSIGNMENT_STATUS'),
        dataIndex: 'assignmentStatus',
        flex: 1,
        renderer: function (value, meta, record) {
            if (!isNullOrEmpty(value)) {
                if (record.data.assignmentStatus != undefined) {
                    return getCommonTranslation(record.data.assignmentStatus) == getCommonTranslation('PENDING') ?
                        "<span style=\'color:red;\'>" + getCommonTranslation(record.data.assignmentStatus) + "</span>" : "<span style=\'color:green;\'>" + getCommonTranslation(record.data.assignmentStatus) + "</span>";
                }
            } else {
                return '-';
            }
        }
    }, {
        header: getCommonTranslation('DURATION_IN_MINS'),
        dataIndex: 'durationInMins',
        flex: 1,
        renderer: function (value, meta, record) {
            if (isNullOrEmpty(value)) {
                return '';
            } else {
                return value;
            }
        }
    }, {
        header: getCommonTranslation('QUESTION_PAPER'),
        dataIndex: 'questionPaperUrlNo',
        flex: 1
    }]
});