/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.examinationcenters.remark.uploaddownload.AssignRemarkDownloadForm', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.assignremarkdownloadform',
    frame: false,
    method: 'POST',
    standardSubmit: false,
    items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		itemId:'remarkLevelField',
		hidden:true,
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'remarkLevel',
			itemId:'remarkLevelId',
			store:Ext.create('Academia.store.examinationcenters.RemarkLevelStore'),
			displayField:'value',
			valueField:'id',
			editable: false,
			queryMode: 'local',
			fieldLabel:getExaminationTranslation('REMARK_LEVEL'),
			value:getExaminationTranslation('SUBJECT_LEVEL')
		},{
			xtype: 'customcombobox',
			name:'userType',
			itemId:'userTypeId',
			store:Ext.create('Academia.store.examinationcenters.remark.ImportStudentRemarkUserTypeStore'),
			fieldLabel:getCommonTranslation('USER_TYPE'),
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			width:226,
			typeAhead:false,
			hidden:true,
			allowBlank:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}, {
    		xtype : 'customcombobox',
			name : 'academicTermT',
			itemId : 'academicTermId',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			valueField : 'id',
			displayField : 'value',
			queryMode: 'local',
			minChars : '3',
			forceSelection : true,
			typeAhead : true,
			hidden:true,
			editable : true,
	    },{

        	xtype: 'checkboxfield',
        	labelAlign: 'right',
        	itemId:'remarkAsHostFacultyDownload',
        	hidden: true,
        	margin:'25 0 0 0',
        	boxLabel: getExaminationTranslation('REMARK_ENTRY_HOST_FACULTY'),
        	name: 'remarkAsHostFacultyDownload',
        	inputValue : true
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		itemId:'assessmentSchemeProgramId',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'importEvaluationPlanType',
			itemId:'importEvaluationPlanTypeItemId',
			store:Ext.create('Academia.store.examCenter.AssignSequence.EvaluationType'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN_TYPE'),
			allowBlank: false
		},{
    		xtype : 'customcombobox',
			name : 'academicTerm',
			itemId : 'academicTerm',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			valueField : 'id',
			displayField : 'value',
			queryMode: 'local',
			minChars:'3',
			typeAhead:true,
			forceSelection : true,
			editable : true,
	//		hideTrigger:false,
			//hidden:true,
	    },{

			xtype: 'customcombobox',
			name:'ImportSubjectLevelcourseId',
			itemId:'ImportSubjectLevelcourseItemId',
			store: Ext.create('Academia.store.examinationcenters.evaluation.CourseofAllPlan'),//'examinationcenters.evaluation.CourseAndVariantsContainsEvaluation',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'displayValue',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			allowBlank:false,
			width:226,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				cls: 'combo-word-break-all',
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.maxWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'ImportRemarkProgramId',
			itemId:'ImportRemarkProgramIdItemId',
			store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.MappedProgramToPlanStore'),
			fieldLabel:getExaminationTranslation('PROGRAM'),
			valueField: 'id',
  			displayField: 'value',
  			queryParam:'programName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			allowBlank:false,
			hidden:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		itemId:'studentLevelProgBatchPeriodId',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'ImportStudentLevelProgramId',
			itemId:'ImportStudentLevelProgramItemId',
			store:Ext.create('Academia.store.common.ClassTeacherProgramStore'),
			fieldLabel:getExaminationTranslation('PROGRAM'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  
		},{
			 xtype: 'customcombobox',
		     name: 'ImportStudentLevelBatchId',
		     itemId:'ImportStudentLevelBatchItemId',
		     store:Ext.create('Academia.store.common.CurrentBatchStore'),
		     displayField:'value',
		     valueField:'id',
		     forceSelection:true,
		     typeAhead:true,
		     disabled:true,
	         allowBlank: false,
		     fieldLabel: getExaminationTranslation('BATCH')
		},{
			 xtype: 'customcombobox',
		     name: 'importStudentLevelPeriodId',
		     itemId:'importStudentLevelPeriodItemId',
		     fieldLabel: getExaminationTranslation('PERIOD'),
		     store:Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
		     displayField:'value',
		     valueField:'id',
		     forceSelection:true,
		     typeAhead:true,
	         allowBlank: false,
		     disabled:true
        }]
	},{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        itemId:'courseLevelBatchPeriodId',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
				 xtype: 'customcombobox',
			     name: 'ImportBatchId',
			     itemId:'ImportBatchIdItemId',
			     store:Ext.create('Academia.store.common.CurrentBatchStore'),
			     displayField:'value',
			     valueField:'id',
			     forceSelection:true,
			     typeAhead:true,
			     disabled:true,
			     hidden:true,
		         //allowBlank: false,
			     fieldLabel: getExaminationTranslation('BATCH')
			},{
				 xtype: 'customcombobox',
			     name: 'importRemarkPeriodId',
			     itemId:'importRemarkPeriodIdItemId',
			     fieldLabel: getExaminationTranslation('PERIOD'),
			     store:Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
			     displayField:'value',
			     valueField:'id',
			     forceSelection:true,
			     hidden:true,
			     typeAhead:true,
		         //allowBlank: false,
			     disabled:true
            },{
        		xtype: 'multiselectcombofield',
        		name: 'ImportRemarkSectionId',
			    itemId:'importRemarkSectionItemId',
			    store:Ext.create('Academia.store.attendance.findRemarkSectionByFacultyAndPeriodId'),
        		displayField:'sectionCode',
        		valueField:'sectionId',
        		forceSelection:true,
        		typeAhead:true,
        		minChars:3,
        		hidden:true,
        		fieldLabel:getExaminationTranslation('SECTION'),
        		//width: 460,
        		autoloadStore: false,
        		disabled:true,
        		listConfig: {
      				listeners: {
     					beforeshow: function(picker) {
     						picker.minWidth = picker.up('combobox').getSize().width;
     					}
     				},
                 }
        	},]
        },{
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        itemId:'categoryFieldItemId',
	        defaults: {
	            width: 226,
	            labelAlign: 'top'
	        },
	        items: [{
		    	  xtype : 'customcombobox',
		    	  name : 'ImportSubjectLevelCategory',
		    	  itemId:'ImportSubjectLevelcategoryId',
		    	  fieldLabel : getExaminationTranslation('CATEGORY'),
		    	  store : Ext.create('Academia.store.examinationcenters.evaluation.OtherCategory'),
		    	  valueField : 'id',
		    	  displayField : 'value',
		    	  editable:false,
		    	 // width:460,
		    	  hidden:true,
		          allowBlank: true,
		          maxLength:512
		      }]
     },{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			 xtype: 'multiselectcombofield',
            name: 'importSubjectLevelcourseVariant',
            itemId:'importSubjectLevelcourseVariantId',
            store:Ext.create('Academia.store.attendance.VariantMappedToPlan'),
            displayField:'value',
            valueField:'id',
            disabled:true,
            cls:'commonAutoHeightMultiselectField resetPasswordMultiselect',
           /* store:'examinationcenters.manageEvaluation.ManageCourseVariantByCourseId',
            displayField:'code',
            valueField:'id',*/
            forceSelection:true,
			typeAhead:true,
            editable:false,
            fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
            autoloadStore: false,
            width:460,
    	}]
	},{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        itemId:'studentLevelsectionIdSchemeLevelItemId',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
    		xtype: 'multiselectcombofield',
    		name: 'ImportStudentLevelSectionId',
    		itemId: 'ImportStudentLevelSectionId',
    	    store:Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID'),
    		displayField:'sectionCode',
    		valueField:'sectionId',
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('SECTION'),
			cls:'resetPasswordMultiselect',
    		width: 460,
    		autoloadStore: false,
    		disabled:true,
    		listConfig: {
  				listeners: {
 					beforeshow: function(picker) {
 						picker.minWidth = picker.up('combobox').getSize().width;
 					}
 				},
             }
    	}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		itemId:'courseLevelEvalPlanId',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
        	xtype: 'customcombobox',
			name:'importSubjectLevelEvaluationPlan',
			itemId:'importSubjectLevelEvaluationPlanId',
			store:Ext.create('Academia.store.examinationcenters.evaluationgroup.detailsequencecovered.EvalGroupEvaluationPlanCombo'),
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
        },{
        	xtype: 'hidden',
            name: 'importevalPlanLevelType'
        },{
            xtype: 'groupingcombobox',
            name: 'importSubjectLevelEvalPlanLevelId',
            itemId:'importSubjectLevelEvalPlanLevelIdItemId',
            labelAlign:'top',
            groupField: 'code',
            groupDisplayField: 'code',
            store: Ext.create('Academia.store.examinationcenters.remark.EvaluationPlanLevelByEvaluationPlanIdStore'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
            valueField: 'id' ,
            minChar : 3,
            disabled:true,
            allowBlank: false,
            forceSelection:true
        },{
			xtype : 'textfield',
			name : 'subjectRemarkLoaderStatusId',
			readOnly : true,
			hidden : true,         
			fieldLabel : getCommonTranslation('REMARK_STATUS') 
			},{
			xtype : 'textfield',
			name : 'remarkMandatoryCheckId',
			readOnly : true,
			hidden : true,         
			fieldLabel : getCommonTranslation('REMARK_STATUS_NEW')  
			}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		itemId:'studentLevelEvalLevel',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [
			{
	        	xtype: 'customcombobox',
				name:'importStudentLevelAssessmentSchemeLevel',
				itemId:'importStudentLevelAssessmentSchemeLevelId',
	    	   // store:'examinationcenters.remark.EvaluationLevelForTeacherRemarkStore',
	    	   // store:'examinationcenters.marksheet.ImportEvaluationLevelTypeNameStore',
	    	    store:Ext.create('Academia.store.examinationcenters.marksheet.FindEvaluationLevelTypeNameByPeriodIdStore'),
	    		displayField:'value',
	    		valueField:'id',
	    		forceSelection:true,
	    		typeAhead:true,
	    		minChars:3,
	    		fieldLabel:getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
	    		disabled:true,
	    		allowBlank:false
	        },{
            xtype: 'groupingcombobox',
            name: 'importStudentLevelEvalPlanLevelId',
            itemId:'importStudentLevelEvalPlanLevelIdItemId',
     	    store:Ext.create('Academia.store.examinationcenters.remark.EvaluationLevelForTeacherRemarkStore'),
//    	    store:'examinationcenters.marksheet.EvaluationLevelTypeNameStore',
    	    displayField:'value',
    		valueField:'value',
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('EVALUATION_LEVEL_NAME'),
    		width: 226,
    		maxLength:1000000,
    		autoloadStore: false,
    		allowBlank:false,
    		disabled:true,
    		//hidden:true
    	/*},{
    		xtype: 'textfield',
    		name: 'marksheetLevel',
    		fieldLabel:getExaminationTranslation('MARKSHEET_LEVEL')*/
    	
        }]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		cls:'windowBtnPos',
		style:{
			marginTop: '30px!important',
			marginLeft: '-2px!important'
		},
		items: [{
            xtype: 'button',
            text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
            itemId: 'downoladBtnAssignRemarkDownloadFormItemId',
            formBind : true,
            ui: 'CustomBtnSubmit'
        }, {
            xtype: 'button',
            itemId: 'resetBtnAssignRemarkDownloadFormItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
	}]
});
