/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.examinationcenters.reports.GradeAverageStudentListGrid', {
	extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.gradeaveragestudentlistgrid',
	store : 'examinationcenters.reports.SubjectListGradeAverageStore',
	autoScroll: true,
	itemId : 'studentGradeObtained',
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'examinationcenters.reports.SubjectListGradeAverageStore',
			emptyMsg :getExaminationTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
		header : getExaminationTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex : .2,
	},
	{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : .2,
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : .2,
		sortable:true,
		hidden:true
	},
	{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : .2,
		sortable:true,
		hidden:true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : .2,
		sortable:true,
		hidden:true
	},
	{
		header : getProgramandcourseTranslation('COURSE_SECTION'),
		dataIndex : 'sectionName',
		flex : .2,
	}] ,
});