/**
 *  @author Amit G
 */

Ext.define('Academia.view.facilitiesresources.managegallery.CourseSectionMapFolderAddCourseGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.coursesectionmapfolderaddcoursegrid',
	title : getCommonTranslation('COURSE_CODE_NAME'),
	store: Ext.create('Academia.store.facilitiesresources.managegallery.MapFolderATCourseVariantStore'),
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: true,
	height:380,
	emptyText: getCommonTranslation('NORESULTSNMESSAGE'),
	viewConfig : {
		deferEmptyText: false,
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	border: true,
	tbar: [{
		xtype:'button',
		itemId: 'nextButton',
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'coursesearchcombo',
		itemId:'coursesearchcombo',
		valueField: 'courseId',
		displayField: 'courseName',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'courseName',
		queryMode: 'remote',
		width:226,
		store: Ext.create('Academia.store.facilitiesresources.managegallery.MapFolderATCourseVariantStore'),
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getCommonTranslation('ACADEMIC_TERM'),
		dataIndex : 'academicTermName',
		flex : 1	 
	},{
		header : getCommonTranslation('COURSE_CODE_NAME'),
		dataIndex : 'courseName',
		flex : 1	 
	}]
});