/**
 *  @author Deepak S
 */

Ext.define('Academia.view.facilitiesresources.managegallery.MapFolderAddProgramBatchGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.mapfolderaddprogrambatchgrid',
	title : getCommonTranslation('PROGRAM_BATCH'),
	store: Ext.create('Academia.store.facilitiesresources.managegallery.MapFolderALProgramBatchStore'),
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	height:380,
	emptyText: getCommonTranslation('NORESULTSNMESSAGE'),
	viewConfig : {
		deferEmptyText: false,
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	border: true,
	tbar: [{
		xtype:'button',
		itemId: 'nextButton',
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	},{
		xtype: 'button',
		text: getCommonTranslation('SUBMITKYS'),
		itemId: 'submitBatchMapping',
		buttonAlign: 'left',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'programbatchsearchcombo',
		itemId:'programbatchsearchcombo',
		store: Ext.create('Academia.store.facilitiesresources.managegallery.MapFolderALProgramBatchStore'),
		valueField: 'batchId',
		displayField: 'batchName',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'qry',
		queryMode: 'remote',
		width:226,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM_BATCH'),
		dataIndex : 'batchName',
		flex : 1	 
	}]
});