/**
 * @author Raghavendra.Soni
 * 
 */
Ext.define('Academia.view.facilitiesresources.managegallery.ShareAlbumGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.sharealbumgrid',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	margin:'0 0 0 0',
	autoScroll: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		//emptyText: getCommonTranslation('EMPTY_MESSAGE')
	},
	store: 'facilitiesresources.managegallery.ShareAlbumStore',
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'facilitiesresources.managegallery.ShareAlbumStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	tbar: [{
		xtype : 'button',
		itemId : 'btnAdd',
		glyph: ICONGLYPH.ADDGLYPH,
		tooltip : getCommonTranslation('ADD')
	},{
		xtype : 'button',
		itemId : 'btnView',
		iconCls: 'view-icon',
		tooltip : getCommonTranslation('VIEW'),
		disabled: true
	},{
		xtype : 'button',
		itemId : 'btnDelete',
		glyph: ICONGLYPH.DELETEGLYPH,
		tooltip : getCommonTranslation('DELETE')
	}],
	columns :[{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex:3
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:2
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionName',
		flex:1
	},{
		header : getCommonTranslation('SHARED_WITH_FACULTY'),
		dataIndex : 'isSharedWithFaculty',
		flex:2
	},{
		header : getCommonTranslation('SHARED_WITH_STUDENT'),
		dataIndex : 'isSharedWithStudent',
		flex:2
	},{
		header : getCommonTranslation('SHARED_WITH_PARENT'),
		dataIndex : 'isSharedWithParent',
		flex:2
	},{
		header : getAlumni('SHARED_WITH_ALUMNI'),
		dataIndex : 'isSharedWithAlumni',
		flex:2
	}]
});
