/**
 * @author Amit G
 */
Ext.define('Academia.view.facilitiesresources.managegallery.ShareCBSDetailsWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.sharecbsdetailswin',
	title:getCommonTranslation('SHARING_DETAILS'),
	frame: true,
	autoScroll:false,
	modal:true,
	plugins : "formlabelrequired",
	layout: {
		type: 'vbox'
	},
	height: 400,
	width: 400,
	items: [{
		xtype: 'fieldcontainer',
		width:'auto',
		defaults: {
			labelAlign: 'top',
			width:300
		},
		items: [{
			xtype: 'checkboxgroup',
			fieldLabel:getCommonTranslation('SHARE_FOLDER_WITH'),
			allowBlank: false,
	        itemId: 'shareAlbumWithSDItemId',
	        labelAlign: 'top',
	        columns: 3,
	        readOnly: true,
	        width:310,
	        items: [
	            {
	            	boxLabel: getCommonTranslation('FACULTY_TABTITLE'),
	            	name: 'faculties',
	            	inputValue: 'faculties',
	            	readOnly: true
	            },
	            {
	            	boxLabel: getCommonTranslation('STUDENTS'),
	            	name: 'students',
	            	inputValue: 'students',
	            	readOnly: true
	            },
	            {
	            	boxLabel: getCommonTranslation('PARENTS'),
	            	name: 'rb',
	            	inputValue: 'parents',
	            	checked:  true,
	            	readOnly: true
	            }
	        ]
		},{
			xtype: 'textfield',
			name: 'academicTerm',
			itemId: 'academicTermItemId',
			readOnly: true,
			fieldLabel:getCommonTranslation('ACADEMIC_TERM')
		},{
			xtype: 'textfield',
			name: 'courseName',
			itemId: 'courseNameItemId',
			readOnly: true,
			fieldLabel:getCommonTranslation('COURSE_CODE_NAME')
		},{
			xtype: 'textfield',
			name: 'courseVariant',
			itemId: 'courseVariantItemId',
			readOnly: true,
			fieldLabel:getCommonTranslation('COURSE_VARIANT')
		}]
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		items: [{
			xtype: 'button',
			text: getFeeAndPaymentCommonTranslation('CANCEL'),
			ui: 'CustomBtnCancel',
			itemId: 'cancelBtnSDWin',
			scale: CONSTANTS.BUTTONSIZE,
			handler: function(btn){
				btn.up('window').close();
			}
		}]
	}]	
});
