/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.facilitiesresources.managegallery.ShareDetailsWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.sharedetailswin',
	title:getCommonTranslation('SHARING_DETAILS'),
	frame: true,
	autoScroll:false,
	modal:true,
	plugins : "formlabelrequired",
	layout: {
		type: 'vbox'
	},
	height: 450,
	width: 360,
	items: [{
		xtype: 'fieldcontainer',
		width:'auto',
		defaults: {
			labelAlign: 'top',
			width:226
		},
		items: [{
			xtype: 'checkboxgroup',
			fieldLabel:getCommonTranslation('SHARE_FOLDER_WITH'),
			allowBlank: false,
	        itemId: 'shareAlbumWithSDItemId',
	        labelAlign: 'top',
	        columns: 4,
	        readOnly: true,
	        width:310,
	        items: [
	            {
	            	boxLabel: getCommonTranslation('FACULTY_TABTITLE'),
	            	name: 'faculties',
	            	inputValue: 'faculties',
	            	readOnly: true
	            },
	            {
	            	boxLabel: getCommonTranslation('STUDENTS'),
	            	name: 'students',
	            	inputValue: 'students',
	            	readOnly: true
	            },
	            {
	            	boxLabel: getCommonTranslation('PARENTS'),
	            	name: 'rb',
	            	inputValue: 'parents',
	            	checked:  true
	            },
	            {
	            	boxLabel: getCommonTranslation('ALUMNI'),
	            	name: 'alumni',
	            	inputValue: 'alumni',
	            	checked:  false,
	            	style:{
	            		marginLeft: '8px'
	            	}
	            }
	        ]
		},{
			xtype: 'textfield',
			name: 'academyLocationSDItemId',
			itemId: 'academyLocationSDItemId',
			allowBlank: false,
			readOnly: true,
			fieldLabel:getCommonTranslation('ACADEMY_LOCATION')
		},{
			xtype: 'textfield',
			name: 'programSDItemId',
			itemId: 'programSDItemId',
			allowBlank: false,
			readOnly: true,
			fieldLabel:getCommonTranslation('PROGRAM')
		},{
			xtype: 'textfield',
			name: 'batchSDItemId',
			itemId: 'batchSDItemId',
			allowBlank: false,
			readOnly: true,
			fieldLabel:getCommonTranslation('BATCH')
		},{
			xtype: 'textfield',
			name: 'sectionSDItemId',
			itemId: 'sectionSDItemId',
			allowBlank: false,
			readOnly: true,
			fieldLabel:getCommonTranslation('SECTION')
		}
		]
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		items: [{
			xtype: 'button',
			text: getFeeAndPaymentCommonTranslation('CANCEL'),
			ui: 'CustomBtnCancel',
			itemId: 'cancelBtnSDWin',
			scale: CONSTANTS.BUTTONSIZE,
			handler: function(btn){
				btn.up('window').close();
			}
		}]
	}]	
});
