/**
 * @author Amit G
 * 
 */
Ext.define('Academia.view.facilitiesresources.managegallery.TnsShareAlbumCourseSectionGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.tnssharealbumcoursesectiongrid',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	margin:'0 0 0 0',
	autoScroll: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		//emptyText: getCommonTranslation('EMPTY_MESSAGE')
	},
	store: 'facilitiesresources.managegallery.ShareAlbumStore',
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'facilitiesresources.managegallery.ShareAlbumStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	tbar: [{
		xtype : 'button',
		itemId : 'btnAdd',
		glyph: ICONGLYPH.ADDGLYPH,
		tooltip : getCommonTranslation('ADD')
	},{
		xtype : 'button',
		itemId : 'btnView',
		iconCls: 'view-icon',
		tooltip : getCommonTranslation('VIEW'),
		disabled: true
	},{
		xtype : 'button',
		itemId : 'btnDelete',
		glyph: ICONGLYPH.DELETEGLYPH,
		tooltip : getCommonTranslation('DELETE')
	}],
	columns :[{
		header : getCommonTranslation('ACADEMIC_TERM'),
		dataIndex : 'academicTerm',
		flex:1
	},{
		header : getCommonTranslation('COURSE_CODE_NAME'),
		dataIndex : 'coursePrintName',
		flex:2
	},{
		header : getCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariant',
		flex:2
	},{
		header : getCommonTranslation('SHARED_WITH_FACULTY'),
		dataIndex : 'isSharedWithFaculty',
		flex:1
	},{
		header : getCommonTranslation('SHARED_WITH_STUDENT'),
		dataIndex : 'isSharedWithStudent',
		flex:1
	},{
		header : getCommonTranslation('SHARED_WITH_PARENT'),
		dataIndex : 'isSharedWithParent',
		flex:1
	}]
});
