/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show Adhoc Resources in grid. 
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormAdhocResourceGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.adhocresourcesgrid',
    border: true,
   /* requires : ['Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormAdhocResourceWindow' ], */
    title: getCommonTranslation('ADHOC_RESOURCES_SELECTED'), //Adhoc Resources Selected		
    columns: [{
        header: getCommonTranslation('RESOURCE_TYPE'), //Resource Type
        dataIndex: 'resourceType',
        flex: .2,
        renderer: function(object) {
            return comboRender(object, 'value');
        }
    }, {
        header: getCommonTranslation('RESOURCE_NAME'), //Resource Name
        dataIndex: 'resourceName',
        flex: .3
    }, {
        header: getCommonTranslation('STATUS'), //Status
        dataIndex: 'isConfirmed',
        flex: .2,
        renderer: function(value) {
        	if (value == true) {
                return getCommonTranslation('CONFIRMED');
            } else {
                return getCommonTranslation('PENDING');
            }
        }
    }],
    initComponent: function() {
        Ext.apply(this, {
            store: Ext.create('Academia.store.facilitiesresources.resourcebooking.AdhocResourceListStore'),
            viewConfig: {
                stripeRows: CONSTANTS.STRIPEROWS
            }
        });
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'), //Add adhoc Resource
        glyph: ICONGLYPH.ADDGLYPH
        //text : getCommonTranslation('ADD')
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        hidden: false,
        tooltip: getCommonTranslation('EDIT'), //Edit adhoc Resource
        glyph: ICONGLYPH.EDITGLYPH
        //text : getCommonTranslation('EDIT')
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'), //View adhoc Resource
        iconCls: 'view-icon'
        //text : getCommonTranslation('VIEW')
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'), //Delete adhoc Resource
        glyph: ICONGLYPH.DELETEGLYPH
        //text : getCommonTranslation('DELETE')
    },{
	    xtype: 'button',
	    tooltip: getCommonTranslation('VIEW_CALENDAR'), //View Calendar  
	    itemId: 'btnViewCalendar',
	    hidden:true,
	    text:getCommonTranslation('VIEW_CALENDAR') //View Calendar
	}],
    showAdhocResourceForm: function() {
        var winAdhocResourceForm = Ext.widget('adhocresourceformwindow');
        winAdhocResourceForm.show();
    }
});