Ext.define('Academia.view.facilitiesresources.resourcemaster.ExternalResourcesGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.externalresourcegrid',
	title:getCommonTranslation('EXTERNAL_FACILITIES_AND_EXTERNAL_EQUIPMENTS'), //External facilities and External Equipments
	border: true,
//	autoScroll:true,
	store:'facilitiesresources.resourcebooking.ExternalResourceListStore',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	style:{
		marginTop:'16px !important',
		marginLeft:'19px !important',
		marginRight:'14px !important'
    },
	columns:[{
		header:getCommonTranslation('CODE'),
		dataIndex:'code',
		flex:0.5
	},{
		header:getCommonTranslation('NAME'),
		dataIndex:'name',
		flex:0.5
	},{
		header:getCommonTranslation('TYPE'),
		dataIndex:'type',
		flex:0.5
	},{
		header:getCommonTranslation('STATUS'),
		dataIndex:'status',
		flex:0.5,
		renderer: function(value) {
        	return getCommonTranslation(value);
        }
	}],
	tbar:[{
        xtype: 'splitbutton',
        itemId: 'spBtnExtrenalResourceTabAddActions',
        //glyph: ICONGLYPH.ADDGLYPH,
     text: getCommonTranslation('MOREACTIONS'), //More Actions
        tooltip: getCommonTranslation('MOREACTIONS'), //Click on this you can perform add equipment/facility operations
        menu: [{	        	
        	tooltip: getCommonTranslation('ADD_FACILITY'),  //ADD_FACILITY
    	    itemId: 'btnAddFacExternalResource',	    
    	    text:getCommonTranslation('ADD_FACILITY') //ADD_FACILITY
        },{
        	tooltip: getCommonTranslation('ADD_EQUIPMENT'),  //ADD_EQUIPMENT
    	    itemId: 'btnAddEquExternalResource',
    	    text:getCommonTranslation('ADD_EQUIPMENT')   //ADD_EQUIPMENT
        }	
        ],listeners: { click: function() { this.showMenu(); } }
    },{
	    xtype: 'button',
	    tooltip: getCommonTranslation('EDIT'),  //Edit
	    itemId: 'btnEdit',
	    glyph: ICONGLYPH.EDITGLYPH	    
//	    text:getCommonTranslation('EDIT') //Edit
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),//View
		iconCls: 'view-icon'
//		text : getCommonTranslation('VIEW')  //View
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		tooltip :getCommonTranslation('DELETE'), //Delete
		cls: 'CustomToolbarBtnReject',
		glyph: ICONGLYPH.DELETEGLYPH
//		text : getCommonTranslation('DELETE') //Delete
	},{
		xtype:'customcombobox',
		fieldLabel:getCommonTranslation('RESOURCE_GROUP'),
		store:'facilitiesresources.resourcebooking.ResourceGroupStore',
		valueField : 'name',
		displayField : 'value',			
		editable:false,
		value:'',
		width:'25%',
		itemId:'cmbResourceGroup',
		queryMode: 'local',
		triggerAction:'all',
		fourceSelection:true	
	},{
		xtype:'customcombobox',
		fieldLabel:getCommonTranslation('RESOURCE_TYPE'),
		store:'facilitiesresources.resourcebooking.ResourceTypeStore',
		displayField:'value',
		valueField:'id',
		value:'',	
		width:'25%',
		itemId:'cmbResourceType',
		queryMode: 'local',
		triggerAction:'all',
		fourceSelection:true
	},{
		xtype:'customcombobox',
		fieldLabel:getCommonTranslation('RESOURCE_STATUS'),
		store:'facilitiesresources.resourcemaster.ResourceStatusStore',
		valueField : 'value',
		displayField : 'name',
		value:'',		
		width:'25%',
		labelWidth: 110,
		itemId:'cmbResourceStatus',
		queryMode: 'local',
		triggerAction:'all',
		fourceSelection:true
	},{
		xtype: 'button',
		text : getCommonTranslation('RESET'),
		itemId : 'resetButtonItemId',
		buttonAlign : 'left',
//		ui : 'CustomBtnCancel',
		scale: CONSTANTS.BUTTONSIZE
	}],
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'facilitiesresources.resourcebooking.ExternalResourceListStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }]
});