/**
 *  @author Abhishek Bais
 */
Ext.define('Academia.view.facultyPortal.attendance.CourseLevelPendingAttendanceReportGridForFaculty', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.courselevelpendingattendancereportgridforfaculty',
	store :'attendance.PendingAttendanceGridStore',
	title : getProgramandcourseTranslation('PENDING_ATTENDANCE_REPORT'),
	border: true,
	refreshStoreData:true,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'personinfofacultyportal':2
		}
	},
	//id:'programBatchesGridId',
	hidden:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		itemId:'dockedItemsItemId',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'attendance.PendingAttendanceGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	initComponent: function() {

		var grid=this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     

	},
	columns : [{
		header : getCommonTranslation('DATE'),
		dataIndex : 'date',
		sortable : true,
		hidden:true,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('COURSE'),
		dataIndex : 'courseName',
		flex : 1,
		sortable : true,
	},{
		header : getCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVaraintName',
		flex : 1,
		sortable : true,
	},{
		header : getCommonTranslation('FACULTY'),
		dataIndex : 'facultyName',
		hidden:true,
		flex : 1,
		sortable : true,
	},{
		header : getCommonTranslation('TOTAL_DAYS'),
		dataIndex : 'totalSession',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('ATTENDANCE_MARKED'),
		dataIndex : 'totalMarkedAttendance',
		flex : 1,
		sortable : true,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getCommonTranslation('ATTENDANCE_PENDING'),
		dataIndex : 'totalPendings',
		flex : 1,
		sortable : true,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	}]

});