Ext.define('Academia.view.feeandpayment.AccountStatementWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.accountStatementWindow',
	title: getFeeAndPaymentCommonTranslation('CANCELLATION_REASONS'),
	modal: true,
	overflowY:'auto',
	maxHeight:600,
	width: '32%',
	height:'35%',
	itemId: 'accountStatementWindowItemId',
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'textarea',
	        name: 'reasonToCancel',
	        itemId: 'reasonToCancelItemId',
	        cls: 'reasonToCancelItemCls',
	        fieldLabel:getFeeAndPaymentCommonTranslation('ACCOUNT_STATEMENT_TRANSACTION_CANCELLATION_REASON_MSG'),
	        allowBlank: false,
	        width:'100%',	        
	        minLength:1,	        
	        maxLength:500,
	        labelAlign: 'top',
//	        style:{
//	        	fontWeight: '700',
//	        }
		},{
	    	xtype: 'fieldcontainer',
	        width : '100%',
			items:[{
				xtype: 'button',
				itemId: 'btnSaveCancel',
				cls: 'CustomToolbarBtnReject',
				ui : 'CustomBtnSubmit',
				formBind : true,
				text : getCommonTranslation('SAVE'),
				tooltip: getCommonTranslation('SAVE'),
			},
			{
				xtype: 'button',
				itemId: 'btnCancel',
				cls: 'CustomToolbarBtnReject',
				ui : 'CustomBtnCancel',
				text : getCommonTranslation('CANCEL'),
				tooltip: getCommonTranslation('CANCEL'),
				handler :function(button) {
	            	button.up('accountStatementWindow').close();
	            }
			}
			]
		}]
	}]
});