/**
 * @author SudarshanReddy
 */

Ext.define('Academia.view.feeandpayment.FeeDoMappingWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.feedomappingwin',
	title:getFeeAndPaymentCommonTranslation('APPLICABLE_FOR'),
	frame: true,
	autoScroll:true,
	modal:true,
	maxHeight: 600,
	items: [{
		xtype: 'form',
		method: 'POST',
		itemId:'feeplandetailform',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'hidden',
			name:'feePlanId',
			itemId:'feePlanId'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'feePlan',
				itemId:'feePlan',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_ID'),
				allowBlank:true,
				readOnly:true
			},{
				xtype: 'datefield',
				itemId:'lastBilledDate',
				fieldLabel: getFeeAndPaymentCommonTranslation('LAST_AUTO_BILL_GENERATET'),
				name: 'lastBilledDate',
				editable:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT
			}]
		},{
			xtype : 'customcombobox',
			name : 'academyLocation',
			itemId:'academyLocation',
			fieldLabel : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
			store:'common.AcademyLocationByName',
			valueField : 'id',
			displayField : 'value',
			allowBlank : false,
			queryParam:'name',
//			triggerAction: '',
			width: 460,
//			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			forceSelection:true,
			minChars:3,
			typeAhead:true,
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'program',
			itemId:'program',
			width: 460,
			fieldLabel: getFeeAndPaymentCommonTranslation('PROGRAM'),
			store: 'feeandpayment.ProgramSmartSearchStore',
			valueField: 'id',
			displayField: 'progCodeOrName',
			allowBlank: false,
			typeAhead:true,
			forceSelection:true,
			queryParam:'programName',
//			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			forceSelection:true,
//			triggerAction: '',
			minChars:3,
			typeAhead:true,
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'batch',
				itemId:'batch',
				fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
				store: 'feeandpayment.BatchSmartSearchStore',
				valueField: 'id',
				displayField: 'value',
				allowBlank: false,
				typeAhead:true,
				forceSelection:true,
				queryParam:'batchName',
//				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				//triggerAction: '',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'textfield',
				name: 'mappingStatus',
				//value:getFeeAndPaymentCommonTranslation('MAPPED'),
				itemId:'mappingStatus',
				readOnly:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('MAPPING_STATUS'),
				allowBlank:true
			}] 
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{		
			xtype: 'multiselectcombofield',
			width: 460,
			name: 'seatType',
			itemId:'seatType',
			fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
			//store: 'enquiry.ProgramBatchSeatTypeStore',
			store: 'feeandpayment.ProgramBatchSeatTypeWithOutEnqStore',
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			typeAhead:true,
			forceSelection:true,
			autoloadStore: false,
			delimiter:null
		},{
			xtype: 'customcombobox',
			width: 460,
			hidden:true,
			name: 'seatTypeEdit',
			queryMode :'local',
			itemId:'seatTypeEdit',
			fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
			//store: 'enquiry.ProgramBatchSeatTypeStore',
			store: 'feeandpayment.ProgramBatchSeatTypeWithOutEnqStore',
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'textfield',
			name: 'period',
			//value:getFeeAndPaymentCommonTranslation('MAPPED'),
			itemId:'period',
			readOnly:true,
			fieldLabel: getCommonTranslation('PERIOD'),
			allowBlank:true
		}]
		}/*,{
				xtype: 'radiogroup',
				itemId:'generateBillId',
				items: [
				        { boxLabel: getFeeAndPaymentCommonTranslation('GENERATE_BILL_PAYMENT_MSSG'), name: 'generateBill', inputValue:true,checked:true},
				        { boxLabel: getFeeAndPaymentCommonTranslation('GENERATE_BILL_STUDENT_MSSG'), name: 'generateBill', inputValue:false}
				        ]
			}*/,{	
				xtype:'fieldcontainer',
				//width:'100%',
				//  cls:'windowBtnPos',
				items: [{
					xtype: 'button',
					action: 'Submit',
					text: getFeeAndPaymentCommonTranslation('SAVE'),
					formBind: true,
					itemId: 'SubmitBtn',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE
				},{
					xtype: 'button',
					text: getFeeAndPaymentCommonTranslation('CANCEL'),
					ui: 'CustomBtnCancel',
					itemId: 'CancelBtn',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]	
	}]
});
