/**
 * @author Prakash Soni
 */
Ext.define('Academia.view.feeandpayment.ManagePaymentPlanSearchForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.managepaymentplansearchform',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width:226
	},
	plugins : "formlabelrequired",
	items: [{
			xtype:'hidden',
			name:'id'
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype: 'customcombobox',
				name: 'program',
				itemId: 'programId',
				width:460,
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				store:Ext.create('Academia.store.common.ProgramByAcademyLocationStore'),
				displayField:'valueCode',
				valueField:'id',
				typeAhead:true,
				forceSelection:true,
				hideTrigger:false,	    
				triggerAction: 'all',
				minChars:3,
				queryParam:'programName',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.maxWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'batch',
				disabled:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
				itemId:'batchId',
				store: 'enquiry.AcademicBatchStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype: 'customcombobox',
				name: 'seatTypeId',
				disabled:true,
				itemId:'seatTypeId',
				fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
				store: Ext.create('Academia.store.common.SeatTypesByBatchId'),
				valueField: 'seatTypeId',
				displayField: 'seatTypeName',
				queryMode : 'local',
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'paymentPlanName',
				itemId:'paymentPlanName',
				//disabled:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_PLAN_NAME'),
				store: 'feeandpayment.FindAllPaymentPlanStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			}]	
		},{	 
			xtype:'fieldset',
			title:getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
			layout:'vbox',
			frame:true,	
			collapsible:true,
			collapsed:true,
			width:'100%',
			defaults: {
				labelAlign: 'top',
				width:226
			},
			style: {
				marginTop: '40px!important'
			},
			items:[{
				xtype:'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign:'top',
					width:226
				},
				items:[{
					xtype: 'customcombobox',
					name: 'mappingStatus',
					itemId:'mappingStatus',
					fieldLabel: getFeeAndPaymentCommonTranslation('MAPPING_STATUS'),
					store: 'feeandpayment.MappingStatus',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true

				},{
					xtype: 'customcombobox',
					name: 'approvalStatus',
					itemId:'approvalStatus',
					fieldLabel: getFeeAndPaymentCommonTranslation('APPROVAL_STATUS'),
					store: 'feeandpayment.FeePlanStatus',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true

				},
				{
					xtype: 'customcombobox',
					name: 'currency',
					itemId:'currency',
					fieldLabel: getFeeAndPaymentCommonTranslation('CURRENCY'),
					store: 'feeandpayment.FeeCurrencyStore',
					valueField: 'id',
					displayField: 'name',
					typeAhead:true,
					forceSelection:true
				}]
			}/*,{
				xtype:'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign:'top',
					width:226
				},
				items:[{
					xtype: 'customcombobox',
					name: 'currency',
					itemId:'currency',
					fieldLabel: getFeeAndPaymentCommonTranslation('CURRENCY'),
					store: 'feeandpayment.FeeCurrencyStore',
					valueField: 'id',
					displayField: 'name',
					typeAhead:true,
					forceSelection:true
				}]
			}*/]
		},{
			xtype: 'panel',
			style:{marginLeft:'-12px',marginBottom:'-5px'},
			width: 'auto',
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	});
