/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.PersonCoveredWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.personcoveredwin',
	title:getFeeAndPaymentCommonTranslation('PERSON_COVERED'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	maxHeight: 600,
	items: [{
		xtype: 'form',
		itemId:'feeplandetailform',
		bodyPadding: '5 5 5 5',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top'
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 275,
				labelAlign: 'top'
			},
			items:[{
					xtype: 'customcombobox',
				    name: 'feePersonIdType',
				    itemId:'idType',
				    fieldLabel: getFeeAndPaymentCommonTranslation('USERS_TYPE'),
				    store: 'feeandpayment.FeePersonIdType',
				    valueField: 'id',
				    displayField: 'value',
				    allowBlank: false,
				    typeAhead:true,
				    //width: 300,
				    forceSelection:true
				},{
					xtype: 'customcombobox',
					name: 'user',
					itemId:'user',
					hidden:true,
					allowBlank:false,
					width:320,
					fieldLabel: getFeeAndPaymentCommonTranslation('USER'),
					store: 'feeandpayment.managebill.User',
					valueField: 'id',
					displayField: 'nameToBePrinted',
					queryParam:'codeOrName',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					typeAhead:false,
					hideTrigger:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code}/{nameToBePrinted}' +
							'</div>';
						}
					}
				},{
					xtype: 'customcombobox',
					name: 'student',
					itemId:'student',
					allowBlank:false,
					hidden:true,
					width:320,
					fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT'),
					store: 'feeandpayment.managebill.Student',
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'studentNameOrCode',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					typeAhead:false,
					hideTrigger:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{studentCode}/{studentName}' +
							'</div>';
						}
					}

				},{
					xtype: 'customcombobox',
					name: 'applicant',
					itemId:'applicant',
					hidden:true,
					allowBlank:true,
					width:320,
					fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT'),
					store: 'feeandpayment.managebill.Applicant',
					valueField: 'id',
					displayField: 'printName',
					queryParam:'codeOrName',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					typeAhead:false,
		            hideTrigger:false,
		            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		            triggerAction: '',
		            forceSelection:true,
					  listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                        '{code}/{printName}' +
			                    '</div>';
			                }
			            }
				}]  
		},
		{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 275,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'radiogroup',
				itemId:'joinType',
				labelAlign:'top',
				fieldLabel: getFeeAndPaymentCommonTranslation('SELECTED_DATE_AS'),
				//columns: 2,
				//width: 290,
				vertical: true,
				items: [
					{ boxLabel: getFeeAndPaymentCommonTranslation('ADHOC_DATE'), name: 'joinType', inputValue:"JOINING_DATE",checked:true},
				        { boxLabel: getFeeAndPaymentCommonTranslation('ADMISSION_DATE'), name: 'joinType', inputValue:"ADMISSION_DATE"}
				        
				        ]
			     },{
				xtype: 'datefield',
	            itemId:'joinDate',
	            fieldLabel: getFeeAndPaymentCommonTranslation('BILLING_START_DATE'),
	            name: 'joinDate',
				width: 226,
	            allowBlank: false,
	            editable:false,
	            listeners: {
	            	render: function(field) {
	            		return dateFormatRender(field);
	            	}
	            }
			}]
			},/*{	
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{	
					xtype: 'datefield',
		            itemId:'withdrawalDate',
		            fieldLabel: getFeeAndPaymentCommonTranslation('WITHDRAWAL_DATE'),
		            name: 'withdrawalDate',
		            editable:false,
		            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
	                submitFormat: CONSTANTS.DATE_FORMAT
				},{
					xtype: 'datefield',
		            itemId:'lastBillDate',
		            fieldLabel: getFeeAndPaymentCommonTranslation('LAST_BILL_DATE'),
		            name: 'lastBilledDate',
		            editable:false,
		            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
	                submitFormat: CONSTANTS.DATE_FORMAT
				}]
		},*/{
			 xtype: 'textfield',
			 name: 'joinSequence',
			 itemId:'joinSequence',
			 hidden:true,
			 readOnly:true,
			 fieldLabel: getFeeAndPaymentCommonTranslation('JOIN_SEQUENCE')
			
		},{	
			  xtype:'fieldcontainer',
			  style:{marginTop:'10px'},
	    	  //width:'100%',
	    	//  cls:'windowBtnPos',
			  items: [{
			    	 xtype: 'button',
					 action: 'Submit',
					 text: getFeeAndPaymentCommonTranslation('SAVE'),
					 formBind: true,
					 itemId: 'SubmitBtn',
					 ui: 'CustomBtnSubmit',
					 scale: CONSTANTS.BUTTONSIZE
			       },{
					 xtype: 'button',
					 text: getFeeAndPaymentCommonTranslation('CANCEL'),
					 ui: 'CustomBtnCancel',
					 itemId: 'CancelBtn',
					 scale: CONSTANTS.BUTTONSIZE
			      }/*,{
			           	 xtype: 'button',
			        	 text: getFeeAndPaymentCommonTranslation('DOWNLOAD_TEMPLATE'),
			             itemId: 'downoladTemplate',
			             hidden:true,
			             ui: 'CustomBtnSubmit'
			        },{
			    	   	 xtype: 'button',
			    	   	 text: getFeeAndPaymentCommonTranslation('UPLOAD_TEMPLATE'),
			    	     itemId: 'uploadPersonCovered',
			    	     hidden:true,
			    	     ui : 'CustomBtnThird'
			    	}*/]
	        }]
		}]	
});
