/**
 *  @author Priyanshi Sharma
 */
Ext.define('Academia.view.feeandpayment.adjustment.ReceiptsListForPaymentSettlement', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.receiptslistforpaymentsettlement',
	title : getFeeAndPaymentCommonTranslation('RECEIPTS'),
	store : 'feeandpayment.adjustment.ReceiptAdjustmentWithPaymentStore',
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	tbar: [{
		itemId: 'submitBtn',
		disabled:true,
		text:getCommonTranslation('SUBMIT'),
		tooltip: getCommonTranslation('SUBMIT')
	}],
	 columns: [{
		 header : getCommonTranslation('RECEIPT_NUMBER'),
		 dataIndex : 'receiptNo',
		 flex : 1	 
	 },{
		 header : getCommonTranslation('RECEIPT_DATE'),
		 dataIndex : 'transactionDate',
		 flex : 1,
		 renderer: function(date) {
			 return dateRender(date);
		 }
	 },{
		 header : getCommonTranslation('VOUCHER_MODE'),
		 dataIndex : 'voucherMode',
		 flex : 1	
	 },{
		 header : getCommonTranslation('NARRATION'),
		 dataIndex : 'narration',
		 hidden : false,
		 flex : 1	
	 },{
		 header : getCommonTranslation('RECEIPT_AMOUNT'),
		 dataIndex : 'amount',
		 flex : 1,
		 renderer:function(value,meta,record){
			 if(!isNullOrEmpty(value)) {
				 return currencyRenderer(value,record.get("currencyId"));
			 }                    
		 } 
	 },{
		 header : getCommonTranslation('ALREADY_ADJUSTED_AMOUNT'),
		 dataIndex : 'totalAdjustedAmount',
		 flex : 1,
		 renderer:function(value,meta,record){
			 if(!isNullOrEmpty(value)) {
				 return currencyRenderer(value,record.get("currencyId"));
			 }                    
		 } 
	 },{
		 header : getCommonTranslation('BALANCE_AMOUNT'),
		 dataIndex : 'totalBalanceAmount',
		 flex : 1,
		 renderer:function(value,meta,record){
			 if(!isNullOrEmpty(value)) {
				 return currencyRenderer(value,record.get("currencyId"));
			 }                    
		 } 
	 },{
		header : getCommonTranslation('AMOUNT_TO_BE_ADJUSTED'),
		dataIndex : 'amountToBeAdjusted',
		flex : 1,
		editing:true,
		itemId : 'amountToBeAdjusted',
		editor : {
			xtype:'numberfield',
			name: 'amountToBeAdjusted',
			itemId:'amountToBeAdjusted',
			mouseWheelEnabled:false,
			allowDecimals:true,
			enableKeyEvents:true,
			hideTrigger:true,
			minValue:0
		},    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		}
	},{
		 header : getCommonTranslation('VIEW_ADJUSTMENTS'),
		 dataIndex : 'viewAdjustments',
		 flex : 1,
		 renderer:function(){
			 return  '<a href="#">View</a>';
		 }
	 }]
});