/**
 * @author Manisha Wagh
 */
Ext.define('Academia.view.feeandpayment.coursefeedefinition.CourseRepetitionCopyWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.courserepetitioncopywindow',
	modal: true,
	frame: true,
	title:getFeeAndPaymentCommonTranslation('COURSE_REPETITION_COPY'),
	items: [{		
    xtype: 'form',
    height:220,
    defaults:{
    	labelAlign:'top',
    	width:226
    },
    standardSubmit: false,
    plugins:"formlabelrequired",    
    items:[
    	{
    		xtype: 'fieldcontainer',
    		defaults:{
    	    	labelAlign:'top',
    	    	width:226
    	    },
    		items:[
    			{
    		    	xtype: 'customcombobox',
    				name: 'copiedEnrollment',
    				itemId:'copiedEnrollmentId',
    				fieldLabel: getFeeAndPaymentCommonTranslation('COPY_FROM_ENROLLMENT'),
    				store: 'feeandpayment.coursefeedefinition.CourseFeeCopyEnrollmentStore',
    				valueField: 'id',
    				displayField: 'enrollmentNo',
    				allowBlank: false,
    				typeAhead:true,
    				forceSelection:true
    			},{
    				xtype :'textfield',
    				name:'enrollmentNo',
    				itemId:'enrollmentNoId',
    				readOnly:true,
    				allowBlank:false,
    				fieldLabel: getCommonTranslation('ENROLLMENT_NUMBER')
    			},
    		]
    	},
	{
		xtype: 'fieldcontainer',
		width:'100%',
		layout:'hbox',
		
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SAVE'),
			itemId: 'btnSubmit',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind: true
		},{
			xtype: 'button',
			text: getCommonTranslation('CANCEL'),
			itemId: 'btnCancel',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		},]	
	},{

		xtype: 'fieldcontainer',
		width:'100%',
		layout:'hbox',
		
		items: [{
			xtype: 'button',
			text: getProgramandcourseTranslation('BTN_CONTINUE_MANUALLY'),
			formBind:false,
			itemId: 'btnContinue',
			ui: 'CustomBtnThird',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	
	}]
	}]
});
